/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.lookup.CachePurge;
import org.graylog2.lookup.LookupDataAdapterRefreshService;
import org.graylog2.lookup.LookupDefaultMultiValue;
import org.graylog2.lookup.LookupDefaultSingleValue;
import org.graylog2.lookup.LookupTable;
import org.graylog2.lookup.db.DBCacheService;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.lookup.db.DBLookupTableService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.lookup.events.CachesDeleted;
import org.graylog2.lookup.events.CachesUpdated;
import org.graylog2.lookup.events.DataAdaptersDeleted;
import org.graylog2.lookup.events.DataAdaptersUpdated;
import org.graylog2.lookup.events.LookupTablesDeleted;
import org.graylog2.lookup.events.LookupTablesUpdated;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.graylog2.utilities.LatchUpdaterListener;
import org.graylog2.utilities.LoggingServiceListener;
import org.graylog2.utilities.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LookupTableService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(LookupTableService.class);
    private DBDataAdapterService dbAdapters;
    private final DBCacheService dbCaches;
    private final DBLookupTableService dbTables;
    private final Map<String, LookupCache.Factory> cacheFactories;
    private final Map<String, LookupDataAdapter.Factory> adapterFactories;
    private final ScheduledExecutorService scheduler;
    private final EventBus eventBus;
    private final LookupDataAdapterRefreshService adapterRefreshService;
    private final ConcurrentMap<String, LookupTable> liveTables = new ConcurrentHashMap<String, LookupTable>();
    private final ConcurrentMap<String, LookupDataAdapter> idToAdapter = new ConcurrentHashMap<String, LookupDataAdapter>();
    private final ConcurrentMap<String, LookupDataAdapter> liveAdapters = new ConcurrentHashMap<String, LookupDataAdapter>();
    private final ConcurrentMap<String, LookupCache> idToCache = new ConcurrentHashMap<String, LookupCache>();
    private final ConcurrentMap<String, LookupCache> liveCaches = new ConcurrentHashMap<String, LookupCache>();

    @Inject
    public LookupTableService(DBDataAdapterService dbAdapters, DBCacheService dbCaches, DBLookupTableService dbTables, Map<String, LookupCache.Factory> cacheFactories, Map<String, LookupDataAdapter.Factory> adapterFactories, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, EventBus eventBus) {
        this.dbAdapters = dbAdapters;
        this.dbCaches = dbCaches;
        this.dbTables = dbTables;
        this.cacheFactories = cacheFactories;
        this.adapterFactories = adapterFactories;
        this.scheduler = scheduler;
        this.eventBus = eventBus;
        this.adapterRefreshService = new LookupDataAdapterRefreshService(scheduler, this.liveTables);
    }

    protected void startUp() throws Exception {
        this.adapterRefreshService.startAsync().awaitRunning();
        CountDownLatch adaptersLatch = this.createAndStartAdapters();
        CountDownLatch cachesLatch = this.createAndStartCaches();
        adaptersLatch.await();
        cachesLatch.await();
        this.createLookupTables();
        this.eventBus.register((Object)this);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
        this.liveTables.clear();
        this.liveCaches.forEach((name, cache) -> {
            cache.addListener(new Service.Listener((LookupCache)((Object)cache), (String)name){
                final /* synthetic */ LookupCache val$cache;
                final /* synthetic */ String val$name;
                {
                    this.val$cache = lookupCache;
                    this.val$name = string;
                }

                public void terminated(Service.State from) {
                    LookupTableService.this.idToCache.remove(this.val$cache.id());
                    LookupTableService.this.liveCaches.remove(this.val$name);
                }
            }, this.scheduler);
            cache.stopAsync();
        });
        this.liveAdapters.forEach((name, adapter) -> {
            adapter.addListener(new Service.Listener((LookupDataAdapter)((Object)adapter), (String)name){
                final /* synthetic */ LookupDataAdapter val$adapter;
                final /* synthetic */ String val$name;
                {
                    this.val$adapter = lookupDataAdapter;
                    this.val$name = string;
                }

                public void terminated(Service.State from) {
                    LookupTableService.this.idToAdapter.remove(this.val$adapter.id());
                    LookupTableService.this.liveAdapters.remove(this.val$name);
                }
            }, this.scheduler);
            adapter.stopAsync();
        });
        this.adapterRefreshService.stopAsync();
    }

    @Subscribe
    public void handleAdapterUpdate(DataAdaptersUpdated updated) {
        this.scheduler.schedule(() -> {
            Collection<LookupTableDto> tablesToUpdate = this.dbTables.findByDataAdapterIds(updated.ids());
            ImmutableSet.Builder existingAdapters = ImmutableSet.builder();
            Set<LookupDataAdapter> newAdapters = this.dbAdapters.findByIds(updated.ids()).stream().map(dto -> this.createAdapter((DataAdapterDto)dto, (ImmutableSet.Builder<LookupDataAdapter>)existingAdapters)).filter(Objects::nonNull).collect(Collectors.toSet());
            CountDownLatch runningLatch = new CountDownLatch(newAdapters.size());
            newAdapters.forEach(adapter -> {
                adapter.addListener(new LatchUpdaterListener(runningLatch), this.scheduler);
                adapter.startAsync();
            });
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)runningLatch);
            tablesToUpdate.forEach(this::createLookupTable);
            existingAdapters.build().forEach(AbstractIdleService::stopAsync);
        }, 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleAdapterDelete(DataAdaptersDeleted deleted) {
        this.scheduler.schedule(() -> deleted.ids().stream().map(this.idToAdapter::remove).filter(Objects::nonNull).forEach(dataAdapter -> {
            this.liveAdapters.remove(dataAdapter.name());
            dataAdapter.stopAsync();
        }), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleCacheUpdate(CachesUpdated updated) {
        this.scheduler.schedule(() -> {
            Collection<LookupTableDto> tablesToUpdate = this.dbTables.findByCacheIds(updated.ids());
            ImmutableSet.Builder existingCaches = ImmutableSet.builder();
            Set<LookupCache> newCaches = this.dbCaches.findByIds(updated.ids()).stream().map(dto -> this.createCache((CacheDto)dto, (ImmutableSet.Builder<LookupCache>)existingCaches)).filter(Objects::nonNull).collect(Collectors.toSet());
            CountDownLatch runningLatch = new CountDownLatch(newCaches.size());
            newCaches.forEach(cache -> {
                cache.addListener(new LatchUpdaterListener(runningLatch), this.scheduler);
                cache.startAsync();
            });
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)runningLatch);
            tablesToUpdate.forEach(this::createLookupTable);
            existingCaches.build().forEach(AbstractIdleService::stopAsync);
        }, 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleCacheDelete(CachesDeleted deleted) {
        this.scheduler.schedule(() -> deleted.ids().stream().map(this.idToCache::remove).filter(Objects::nonNull).forEach(lookupCache -> {
            this.liveCaches.remove(lookupCache.name());
            lookupCache.stopAsync();
        }), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleLookupTableUpdate(LookupTablesUpdated updated) {
        this.scheduler.schedule(() -> updated.lookupTableIds().forEach(id -> this.dbTables.get((String)id).map(this::createLookupTable)), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handleLookupTableDelete(LookupTablesDeleted deleted) {
        this.scheduler.schedule(() -> deleted.lookupTableNames().forEach(this.liveTables::remove), 0L, TimeUnit.SECONDS);
    }

    private CountDownLatch createAndStartAdapters() {
        Set<LookupDataAdapter> adapters = this.dbAdapters.findAll().stream().map(dto -> this.createAdapter((DataAdapterDto)dto, null)).filter(Objects::nonNull).collect(Collectors.toSet());
        CountDownLatch latch = new CountDownLatch(Math.toIntExact(adapters.size()));
        adapters.forEach(adapter -> {
            adapter.addListener(new LatchUpdaterListener(latch), this.scheduler);
            adapter.startAsync();
        });
        return latch;
    }

    private LookupDataAdapter createAdapter(final DataAdapterDto dto, ImmutableSet.Builder<LookupDataAdapter> existingAdapters) {
        try {
            LookupDataAdapter.Factory factory = this.adapterFactories.get(dto.config().type());
            if (factory == null) {
                LOG.warn("Unable to load data adapter {} of type {}, missing a factory. Is a required plugin missing?", (Object)dto.name(), (Object)dto.config().type());
                return null;
            }
            Object adapter = factory.create(dto.id(), dto.name(), dto.config());
            adapter.addListener((Service.Listener)new LoggingServiceListener("Data Adapter", String.format(Locale.ENGLISH, "%s/%s [@%s]", dto.name(), dto.id(), ObjectUtils.objectId(adapter)), LOG), (Executor)this.scheduler);
            adapter.addListener(new Service.Listener((LookupDataAdapter)((Object)adapter), (ImmutableSet.Builder)existingAdapters){
                final /* synthetic */ LookupDataAdapter val$adapter;
                final /* synthetic */ ImmutableSet.Builder val$existingAdapters;
                {
                    this.val$adapter = lookupDataAdapter;
                    this.val$existingAdapters = builder;
                }

                public void running() {
                    LookupTableService.this.idToAdapter.put(dto.id(), this.val$adapter);
                    LookupDataAdapter existing = LookupTableService.this.liveAdapters.put(dto.name(), this.val$adapter);
                    if (existing != null && this.val$existingAdapters != null) {
                        this.val$existingAdapters.add((Object)existing);
                    }
                }

                public void failed(Service.State from, Throwable failure) {
                    LOG.warn("Unable to start data adapter {}: {}", (Object)dto.name(), (Object)ExceptionUtils.getRootCauseMessage(failure));
                }
            }, (Executor)this.scheduler);
            adapter.addListener((Service.Listener)this.adapterRefreshService.newServiceListener((LookupDataAdapter)((Object)adapter)), (Executor)this.scheduler);
            return adapter;
        }
        catch (Exception e) {
            LOG.error("Couldn't create adapter <{}/{}>", new Object[]{dto.name(), dto.id(), e});
            return null;
        }
    }

    private CountDownLatch createAndStartCaches() {
        Set<LookupCache> caches = this.dbCaches.findAll().stream().map(dto -> this.createCache((CacheDto)dto, null)).filter(Objects::nonNull).collect(Collectors.toSet());
        CountDownLatch latch = new CountDownLatch(Math.toIntExact(caches.size()));
        caches.forEach(lookupCache -> {
            lookupCache.addListener(new LatchUpdaterListener(latch), this.scheduler);
            lookupCache.startAsync();
        });
        return latch;
    }

    private LookupCache createCache(final CacheDto dto, @Nullable ImmutableSet.Builder<LookupCache> existingCaches) {
        try {
            LookupCache.Factory factory = this.cacheFactories.get(dto.config().type());
            if (factory == null) {
                LOG.warn("Unable to load cache {} of type {}, missing a factory. Is a required plugin missing?", (Object)dto.name(), (Object)dto.config().type());
                return null;
            }
            Object cache = factory.create(dto.id(), dto.name(), dto.config());
            cache.addListener((Service.Listener)new LoggingServiceListener("Cache", String.format(Locale.ENGLISH, "%s/%s [@%s]", dto.name(), dto.id(), ObjectUtils.objectId(cache)), LOG), (Executor)this.scheduler);
            cache.addListener(new Service.Listener((LookupCache)((Object)cache), (ImmutableSet.Builder)existingCaches){
                final /* synthetic */ LookupCache val$cache;
                final /* synthetic */ ImmutableSet.Builder val$existingCaches;
                {
                    this.val$cache = lookupCache;
                    this.val$existingCaches = builder;
                }

                public void running() {
                    LookupTableService.this.idToCache.put(dto.id(), this.val$cache);
                    LookupCache existing = LookupTableService.this.liveCaches.put(dto.name(), this.val$cache);
                    if (existing != null && this.val$existingCaches != null) {
                        this.val$existingCaches.add((Object)existing);
                    }
                }

                public void failed(Service.State from, Throwable failure) {
                    LOG.warn("Unable to start cache {}: {}", (Object)dto.name(), (Object)ExceptionUtils.getRootCauseMessage(failure));
                }
            }, (Executor)this.scheduler);
            return cache;
        }
        catch (Exception e) {
            LOG.error("Couldn't create cache <{}/{}>", new Object[]{dto.name(), dto.id(), e});
            return null;
        }
    }

    private void createLookupTables() {
        try {
            this.dbTables.forEach(dto -> {
                try {
                    this.createLookupTable((LookupTableDto)dto);
                }
                catch (Exception e) {
                    LOG.error("Couldn't create lookup table <{}/{}>: {}", new Object[]{dto.name(), dto.id(), e.getMessage()});
                }
            });
        }
        catch (Exception e) {
            LOG.error("Couldn't create lookup tables", (Throwable)e);
        }
    }

    private LookupTable createLookupTable(LookupTableDto dto) {
        LookupDefaultMultiValue defaultMultiValue;
        LookupDefaultSingleValue defaultSingleValue;
        LookupCache cache = (LookupCache)((Object)this.idToCache.get(dto.cacheId()));
        if (cache == null) {
            LOG.warn("Lookup table {} is referencing a missing cache {}, check if it started properly.", (Object)dto.name(), (Object)dto.cacheId());
            return null;
        }
        LookupDataAdapter adapter = (LookupDataAdapter)((Object)this.idToAdapter.get(dto.dataAdapterId()));
        if (adapter == null) {
            LOG.warn("Lookup table {} is referencing a missing data adapter {}, check if it started properly.", (Object)dto.name(), (Object)dto.dataAdapterId());
            return null;
        }
        try {
            defaultSingleValue = LookupDefaultSingleValue.create(dto.defaultSingleValue(), dto.defaultSingleValueType());
        }
        catch (Exception e) {
            LOG.error("Could not create default single value object for lookup table {}/{}: {}", new Object[]{dto.name(), dto.id(), e.getMessage()});
            return null;
        }
        try {
            defaultMultiValue = LookupDefaultMultiValue.create(dto.defaultMultiValue(), dto.defaultMultiValueType());
        }
        catch (Exception e) {
            LOG.error("Could not create default multi value object for lookup table {}/{}: {}", new Object[]{dto.name(), dto.id(), e.getMessage()});
            return null;
        }
        LookupTable table = LookupTable.builder().id(dto.id()).name(dto.name()).description(dto.description()).title(dto.title()).cache(cache).dataAdapter(adapter).defaultSingleValue(defaultSingleValue).defaultMultiValue(defaultMultiValue).build();
        LookupCache newCache = table.cache();
        LookupDataAdapter newAdapter = table.dataAdapter();
        LOG.info("Starting lookup table {}/{} [@{}] using cache {}/{} [@{}], data adapter {}/{} [@{}]", new Object[]{table.name(), table.id(), ObjectUtils.objectId(table), newCache.name(), newCache.id(), ObjectUtils.objectId((Object)newCache), newAdapter.name(), newAdapter.id(), ObjectUtils.objectId((Object)newAdapter)});
        LookupTable previous = this.liveTables.put(dto.name(), table);
        if (previous != null) {
            LOG.info("Replaced previous lookup table {} [@{}]", (Object)previous.name(), (Object)ObjectUtils.objectId(previous));
        }
        return table;
    }

    public Optional<CachePurge> newCachePurge(String tableName) {
        LookupTable table = this.getTable(tableName);
        if (table != null) {
            return Optional.of(new CachePurge(this.liveTables, table.dataAdapter()));
        }
        return Optional.empty();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Nullable
    private LookupTable getTable(String name) {
        LookupTable lookupTable = (LookupTable)this.liveTables.get(name);
        if (lookupTable == null) {
            LOG.warn("Lookup table <{}> does not exist", (Object)name);
        }
        return lookupTable;
    }

    public boolean hasTable(String name) {
        if (this.liveTables.containsKey(name)) {
            return true;
        }
        try {
            return this.dbTables.get(name).isPresent();
        }
        catch (Exception e) {
            LOG.error("Couldn't load lookup table <{}> from database", (Object)name, (Object)e);
            return false;
        }
    }

    public Collection<LookupDataAdapter> getDataAdapters(Set<String> adapterNames) {
        if (adapterNames == null) {
            return Collections.emptySet();
        }
        return adapterNames.stream().map(this.liveAdapters::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Collection<LookupCache> getCaches(Set<String> cacheNames) {
        if (cacheNames == null) {
            return Collections.emptySet();
        }
        return cacheNames.stream().map(this.liveCaches::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static class Function {
        private final LookupTableService lookupTableService;
        private final String lookupTableName;

        public Function(LookupTableService lookupTableService, String lookupTableName) {
            this.lookupTableService = lookupTableService;
            this.lookupTableName = lookupTableName;
        }

        @Nullable
        public LookupResult lookup(@Nonnull Object key) {
            LookupTable lookupTable = this.lookupTableService.getTable(this.lookupTableName);
            if (lookupTable == null) {
                return LookupResult.empty();
            }
            LookupResult result = lookupTable.lookup(key);
            if (result == null || result.isEmpty()) {
                return LookupResult.empty();
            }
            return result;
        }

        public LookupTable getTable() {
            return this.lookupTableService.getTable(this.lookupTableName);
        }
    }

    public static class Builder {
        private final LookupTableService lookupTableService;
        private String lookupTableName;

        public Builder(LookupTableService lookupTableService) {
            this.lookupTableService = lookupTableService;
        }

        public Builder lookupTable(String name) {
            this.lookupTableName = name;
            return this;
        }

        public Function build() {
            return new Function(this.lookupTableService, this.lookupTableName);
        }
    }
}

