/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.events.DataAdaptersDeleted;
import org.graylog2.lookup.events.DataAdaptersUpdated;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class DBDataAdapterService {
    private final JacksonDBCollection<DataAdapterDto, ObjectId> db;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public DBDataAdapterService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterEventBus) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection("lut_data_adapters"), DataAdapterDto.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.clusterEventBus = clusterEventBus;
        this.db.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    public Optional<DataAdapterDto> get(String idOrName) {
        try {
            return Optional.ofNullable((DataAdapterDto)this.db.findOneById((Object)new ObjectId(idOrName)));
        }
        catch (IllegalArgumentException e) {
            return Optional.ofNullable((DataAdapterDto)this.db.findOne(DBQuery.is((String)"name", (Object)idOrName)));
        }
    }

    public DataAdapterDto save(DataAdapterDto table) {
        WriteResult save = this.db.save((Object)table);
        DataAdapterDto savedDataAdapter = (DataAdapterDto)save.getSavedObject();
        this.clusterEventBus.post(DataAdaptersUpdated.create(savedDataAdapter.id()));
        return savedDataAdapter;
    }

    public PaginatedList<DataAdapterDto> findPaginated(DBQuery.Query query, DBSort.SortBuilder sort, int page, int perPage) {
        try (DBCursor cursor = this.db.find(query).sort((DBObject)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));){
            PaginatedList<DataAdapterDto> paginatedList = new PaginatedList<DataAdapterDto>((List<DataAdapterDto>)this.asImmutableList((Iterator<? extends DataAdapterDto>)cursor), cursor.count(), page, perPage);
            return paginatedList;
        }
    }

    private ImmutableList<DataAdapterDto> asImmutableList(Iterator<? extends DataAdapterDto> cursor) {
        return ImmutableList.copyOf(cursor);
    }

    public void delete(String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.get(idOrName);
        dataAdapterDto.map(DataAdapterDto::id).map(ObjectId::new).ifPresent(arg_0 -> this.db.removeById(arg_0));
        dataAdapterDto.ifPresent(dataAdapter -> this.clusterEventBus.post(DataAdaptersDeleted.create(dataAdapter.id())));
    }

    public Collection<DataAdapterDto> findByIds(Set<String> idSet) {
        DBQuery.Query query = DBQuery.in((String)"_id", (Collection)idSet.stream().map(ObjectId::new).collect(Collectors.toList()));
        try (DBCursor cursor = this.db.find(query);){
            ImmutableList<DataAdapterDto> immutableList = this.asImmutableList((Iterator<? extends DataAdapterDto>)cursor);
            return immutableList;
        }
    }

    public Collection<DataAdapterDto> findAll() {
        try (DBCursor cursor = this.db.find();){
            ImmutableList<DataAdapterDto> immutableList = this.asImmutableList((Iterator<? extends DataAdapterDto>)cursor);
            return immutableList;
        }
    }
}

