/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantMillisProvider
implements DateTimeUtils.MillisProvider {
    private static final Logger log = LoggerFactory.getLogger(InstantMillisProvider.class);
    private DateTime currentTick;

    public InstantMillisProvider(DateTime instant) {
        this.setTimeTo(instant);
    }

    public void setTimeTo(DateTime instant) {
        log.debug("Setting clock to {}", (Object)instant);
        this.currentTick = instant;
    }

    public long getMillis() {
        return this.currentTick.getMillis();
    }

    public void tick(Period period) {
        this.currentTick = this.currentTick.plus((ReadablePeriod)period);
        log.debug("Ticking clock by {} to {}", (Object)period, (Object)this.currentTick);
    }
}

