/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.util.Size;
import java.nio.file.Path;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.graylog2.configuration.PathConfiguration;
import org.joda.time.Duration;

public class KafkaJournalConfiguration
extends PathConfiguration {
    @Parameter(value="message_journal_dir", required=true)
    @JsonProperty(value="directory")
    private Path messageJournalDir = this.getDataDir().resolve("journal");
    @Parameter(value="message_journal_segment_size")
    @JsonProperty(value="segment_size")
    private Size messageJournalSegmentSize = Size.megabytes((long)100L);
    @Parameter(value="message_journal_segment_age")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    @JsonProperty(value="segment_age")
    private Duration messageJournalSegmentAge = Duration.standardHours((long)1L);
    @Parameter(value="message_journal_max_size")
    @JsonProperty(value="max_size")
    private Size messageJournalMaxSize = Size.gigabytes((long)5L);
    @Parameter(value="message_journal_max_age")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    @JsonProperty(value="max_age")
    private Duration messageJournalMaxAge = Duration.standardHours((long)12L);
    @Parameter(value="message_journal_flush_interval")
    @JsonProperty(value="flush_interval")
    private long messageJournalFlushInterval = 1000000L;
    @Parameter(value="message_journal_flush_age")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    @JsonProperty(value="flush_age")
    private Duration messageJournalFlushAge = Duration.standardMinutes((long)1L);

    public KafkaJournalConfiguration() {
    }

    @JsonCreator
    public KafkaJournalConfiguration(@NotNull @JsonProperty(value="directory") Path messageJournalDir, @JsonProperty(value="segment_size") long messageJournalSegmentSize, @JsonProperty(value="segment_age") Duration messageJournalSegmentAge, @JsonProperty(value="max_size") long messageJournalMaxSize, @JsonProperty(value="max_age") Duration messageJournalMaxAge, @JsonProperty(value="flush_interval") long messageJournalFlushInterval, @JsonProperty(value="flush_age") Duration messageJournalFlushAge) {
        this.messageJournalDir = Objects.requireNonNull(messageJournalDir);
        this.messageJournalSegmentSize = Size.bytes((long)messageJournalSegmentSize);
        this.messageJournalSegmentAge = messageJournalSegmentAge;
        this.messageJournalMaxSize = Size.bytes((long)messageJournalMaxSize);
        this.messageJournalMaxAge = messageJournalMaxAge;
        this.messageJournalFlushInterval = messageJournalFlushInterval;
        this.messageJournalFlushAge = messageJournalFlushAge;
    }

    public Path getMessageJournalDir() {
        return this.messageJournalDir;
    }

    public Size getMessageJournalSegmentSize() {
        return this.messageJournalSegmentSize;
    }

    public Duration getMessageJournalSegmentAge() {
        return this.messageJournalSegmentAge;
    }

    public Duration getMessageJournalMaxAge() {
        return this.messageJournalMaxAge;
    }

    public Size getMessageJournalMaxSize() {
        return this.messageJournalMaxSize;
    }

    public long getMessageJournalFlushInterval() {
        return this.messageJournalFlushInterval;
    }

    public Duration getMessageJournalFlushAge() {
        return this.messageJournalFlushAge;
    }
}

