/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.graylog2.plugin.Message;
import org.joda.time.DateTime;

public class MessageSummary {
    private static final HashSet<String> RESERVED_FIELDS = Sets.newHashSet((Object[])new String[]{"_id", "message", "source", "timestamp", "streams"});
    @JsonIgnore
    private final String index;
    @JsonIgnore
    private final Message message;

    public MessageSummary(String index, Message message) {
        this.index = index;
        this.message = message;
    }

    @JsonProperty
    public String getIndex() {
        return this.index;
    }

    @JsonProperty
    public String getId() {
        return this.message.getId();
    }

    @JsonProperty
    public String getSource() {
        return this.message.getSource();
    }

    @JsonProperty
    public String getMessage() {
        return this.message.getMessage();
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.message.getTimestamp();
    }

    @JsonProperty
    public Collection<String> getStreamIds() {
        return this.message.getStreamIds();
    }

    @JsonProperty
    public Map<String, Object> getFields() {
        HashMap genericFields = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : this.message.getFieldsEntries()) {
            if (RESERVED_FIELDS.contains(entry.getKey())) continue;
            genericFields.put(entry.getKey(), entry.getValue());
        }
        return genericFields;
    }

    @JsonIgnore
    public boolean hasField(String key) {
        return this.message.hasField(key);
    }

    @JsonIgnore
    public Object getField(String key) {
        return this.message.getField(key);
    }

    @JsonIgnore
    public Message getRawMessage() {
        return this.message;
    }
}

