/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.lookup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.lookup.LookupDefaultMultiValue;
import org.graylog2.lookup.LookupDefaultSingleValue;
import org.graylog2.plugin.lookup.AutoValue_LookupResult;

@AutoValue
public abstract class LookupResult {
    private static final LookupResult EMPTY_LOOKUP_RESULT = LookupResult.builder().cacheTTL(Long.MAX_VALUE).build();
    public static final String SINGLE_VALUE_KEY = "value";

    @JsonProperty(value="single_value")
    @Nullable
    public abstract Object singleValue();

    @JsonProperty(value="multi_value")
    @Nullable
    public abstract Map<Object, Object> multiValue();

    @JsonProperty(value="ttl")
    public abstract long cacheTTL();

    @JsonIgnore
    public boolean isEmpty() {
        return this.singleValue() == null && this.multiValue() == null;
    }

    public static LookupResult empty() {
        return EMPTY_LOOKUP_RESULT;
    }

    public static LookupResult single(CharSequence singleValue) {
        return LookupResult.multi(singleValue, Collections.singletonMap(SINGLE_VALUE_KEY, singleValue));
    }

    public static LookupResult single(Number singleValue) {
        return LookupResult.multi(singleValue, Collections.singletonMap(SINGLE_VALUE_KEY, singleValue));
    }

    public static LookupResult single(Boolean singleValue) {
        return LookupResult.multi(singleValue, Collections.singletonMap(SINGLE_VALUE_KEY, singleValue));
    }

    public static LookupResult multi(CharSequence singleValue, Map<Object, Object> multiValue) {
        return LookupResult.withoutTTL().single(singleValue).multiValue(multiValue).build();
    }

    public static LookupResult multi(Number singleValue, Map<Object, Object> multiValue) {
        return LookupResult.withoutTTL().single(singleValue).multiValue(multiValue).build();
    }

    public static LookupResult multi(Boolean singleValue, Map<Object, Object> multiValue) {
        return LookupResult.withoutTTL().single(singleValue).multiValue(multiValue).build();
    }

    public static LookupResult withDefaults(LookupDefaultSingleValue singleValue, LookupDefaultMultiValue multiValue) {
        Builder builder = LookupResult.withoutTTL();
        switch (singleValue.valueType()) {
            case STRING: {
                builder = builder.single((CharSequence)singleValue.value());
                break;
            }
            case NUMBER: {
                builder = builder.single((Number)singleValue.value());
                break;
            }
            case BOOLEAN: {
                builder = builder.single((Boolean)singleValue.value());
                break;
            }
            case OBJECT: {
                throw new IllegalArgumentException("Single value cannot be of type OBJECT");
            }
        }
        if (multiValue.isSet()) {
            builder = builder.multiValue((Map<Object, Object>)multiValue.value());
        } else if (singleValue.isSet()) {
            builder = builder.multiValue(Collections.singletonMap(SINGLE_VALUE_KEY, singleValue.value()));
        }
        return builder.build();
    }

    @JsonCreator
    public static LookupResult createFromJSON(@JsonProperty(value="single_value") Object singleValue, @JsonProperty(value="multi_value") Map<Object, Object> multiValue, @JsonProperty(value="ttl") long cacheTTL) {
        return LookupResult.builder().singleValue(singleValue).multiValue(multiValue).cacheTTL(cacheTTL).build();
    }

    public static Builder withoutTTL() {
        return LookupResult.builder().cacheTTL(Long.MAX_VALUE);
    }

    public static Builder builder() {
        return new AutoValue_LookupResult.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder singleValue(Object var1);

        public abstract Builder multiValue(Map<Object, Object> var1);

        public abstract Builder cacheTTL(long var1);

        public Builder single(CharSequence singleValue) {
            return this.singleValue(singleValue);
        }

        public Builder single(Number singleValue) {
            return this.singleValue(singleValue);
        }

        public Builder single(Boolean singleValue) {
            return this.singleValue(singleValue);
        }

        public Builder multiSingleton(Object value) {
            return this.multiValue(Collections.singletonMap(LookupResult.SINGLE_VALUE_KEY, value));
        }

        public abstract LookupResult build();
    }
}

