/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.Match;
import io.krakens.grok.api.exception.GrokException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.rest.models.tools.requests.GrokTestRequest;
import org.graylog2.rest.resources.tools.responses.GrokTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/grok_tester")
@Produces(value={"application/json"})
public class GrokTesterResource
extends RestResource {
    private final GrokPatternService grokPatternService;

    @Inject
    public GrokTesterResource(GrokPatternService grokPatternService) {
        this.grokPatternService = grokPatternService;
    }

    @GET
    @Timed
    public GrokTesterResponse grokTest(@QueryParam(value="pattern") @NotEmpty String pattern, @QueryParam(value="string") @NotNull String string, @QueryParam(value="named_captures_only") @NotNull boolean namedCapturesOnly) throws GrokException {
        return this.doTestGrok(string, pattern, namedCapturesOnly);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to test Grok patterns")
    public GrokTesterResponse testGrok(@Valid @NotNull GrokTestRequest grokTestRequest) throws GrokException {
        return this.doTestGrok(grokTestRequest.string(), grokTestRequest.pattern(), grokTestRequest.namedCapturesOnly());
    }

    private GrokTesterResponse doTestGrok(String string, String pattern, boolean namedCapturesOnly) throws GrokException {
        GrokTesterResponse response;
        Grok grok;
        Set<GrokPattern> grokPatterns = this.grokPatternService.loadAll();
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern grokPattern : grokPatterns) {
            grokCompiler.register(grokPattern.name(), grokPattern.pattern());
        }
        try {
            grok = grokCompiler.compile(pattern, namedCapturesOnly);
        }
        catch (Exception e) {
            return GrokTesterResponse.createError(pattern, string, e.getMessage());
        }
        Match match = grok.match((CharSequence)string);
        Map matches = match.capture();
        if (matches.isEmpty()) {
            response = GrokTesterResponse.createSuccess(false, Collections.emptyList(), pattern, string);
        } else {
            ArrayList responseMatches = Lists.newArrayList();
            for (Map.Entry entry : matches.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                responseMatches.add(GrokTesterResponse.Match.create((String)entry.getKey(), value.toString()));
            }
            response = GrokTesterResponse.createSuccess(true, responseMatches, pattern, string);
        }
        return response;
    }
}

