/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.rest.models.system.inputs.responses.InputTypeInfo;
import org.graylog2.rest.models.system.inputs.responses.InputTypesSummary;
import org.graylog2.shared.inputs.InputDescription;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Inputs/Types", description="Message input types of this node")
@Path(value="/system/inputs/types")
@Produces(value={"application/json"})
public class InputTypesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(InputTypesResource.class);
    private final MessageInputFactory messageInputFactory;

    @Inject
    public InputTypesResource(MessageInputFactory messageInputFactory) {
        this.messageInputFactory = messageInputFactory;
    }

    @GET
    @Timed
    @ApiOperation(value="Get all available input types of this node")
    public InputTypesSummary types() {
        HashMap<String, String> types = new HashMap<String, String>();
        for (Map.Entry<String, InputDescription> entry : this.messageInputFactory.getAvailableInputs().entrySet()) {
            types.put(entry.getKey(), entry.getValue().getName());
        }
        return InputTypesSummary.create(types);
    }

    @GET
    @Timed
    @Path(value="/all")
    @ApiOperation(value="Get information about all input types")
    public Map<String, InputTypeInfo> all() {
        Map<String, InputDescription> availableTypes = this.messageInputFactory.getAvailableInputs();
        return availableTypes.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            InputDescription description = (InputDescription)entry.getValue();
            return InputTypeInfo.create((String)entry.getKey(), description.getName(), description.isExclusive(), description.getRequestedConfiguration(), description.getLinkToDocs());
        }));
    }

    @GET
    @Timed
    @Path(value="{inputType}")
    @ApiOperation(value="Get information about a single input type")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input type registered.")})
    public InputTypeInfo info(@ApiParam(name="inputType", required=true) @PathParam(value="inputType") String inputType) {
        InputDescription description = this.messageInputFactory.getAvailableInputs().get(inputType);
        if (description == null) {
            String message = "Unknown input type " + inputType + " requested.";
            LOG.error(message);
            throw new NotFoundException(message);
        }
        return InputTypeInfo.create(inputType, description.getName(), description.isExclusive(), description.getRequestedConfiguration(), description.getLinkToDocs());
    }
}

