/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats;

import com.google.inject.AbstractModule;
import org.graylog2.shared.system.stats.SigarService;
import org.graylog2.shared.system.stats.fs.FsProbe;
import org.graylog2.shared.system.stats.fs.JmxFsProbe;
import org.graylog2.shared.system.stats.fs.SigarFsProbe;
import org.graylog2.shared.system.stats.jvm.JvmProbe;
import org.graylog2.shared.system.stats.network.JmxNetworkProbe;
import org.graylog2.shared.system.stats.network.NetworkProbe;
import org.graylog2.shared.system.stats.network.SigarNetworkProbe;
import org.graylog2.shared.system.stats.os.JmxOsProbe;
import org.graylog2.shared.system.stats.os.OsProbe;
import org.graylog2.shared.system.stats.os.SigarOsProbe;
import org.graylog2.shared.system.stats.process.JmxProcessProbe;
import org.graylog2.shared.system.stats.process.ProcessProbe;
import org.graylog2.shared.system.stats.process.SigarProcessProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemStatsModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(SystemStatsModule.class);
    private final boolean disableSigar;

    public SystemStatsModule(boolean disableSigar) {
        this.disableSigar = disableSigar;
    }

    protected void configure() {
        boolean sigarLoaded = false;
        if (this.disableSigar) {
            LOG.debug("SIGAR disabled. Using JMX implementations.");
        } else {
            try {
                SigarService sigarService = new SigarService();
                if (sigarService.isReady()) {
                    this.bind(SigarService.class).toInstance((Object)sigarService);
                    this.bind(FsProbe.class).to(SigarFsProbe.class).asEagerSingleton();
                    this.bind(NetworkProbe.class).to(SigarNetworkProbe.class).asEagerSingleton();
                    this.bind(OsProbe.class).to(SigarOsProbe.class).asEagerSingleton();
                    this.bind(ProcessProbe.class).to(SigarProcessProbe.class).asEagerSingleton();
                    sigarLoaded = true;
                }
            }
            catch (Throwable e) {
                LOG.debug("Failed to load SIGAR. Falling back to JMX implementations.", e);
            }
        }
        if (!sigarLoaded) {
            this.bind(FsProbe.class).to(JmxFsProbe.class).asEagerSingleton();
            this.bind(NetworkProbe.class).to(JmxNetworkProbe.class).asEagerSingleton();
            this.bind(OsProbe.class).to(JmxOsProbe.class).asEagerSingleton();
            this.bind(ProcessProbe.class).to(JmxProcessProbe.class).asEagerSingleton();
        }
        this.bind(JvmProbe.class).asEagerSingleton();
    }
}

