/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.network;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import org.graylog2.shared.system.stats.SigarService;
import org.graylog2.shared.system.stats.network.NetworkProbe;
import org.graylog2.shared.system.stats.network.NetworkStats;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Tcp;

public class SigarNetworkProbe
implements NetworkProbe {
    private final SigarService sigarService;

    @Inject
    public SigarNetworkProbe(SigarService sigarService) {
        this.sigarService = sigarService;
    }

    @Override
    public synchronized NetworkStats networkStats() {
        NetworkStats.TcpStats tcpStats;
        String primaryInterface;
        Sigar sigar = this.sigarService.sigar();
        try {
            NetInterfaceConfig netInterfaceConfig = sigar.getNetInterfaceConfig(null);
            primaryInterface = netInterfaceConfig.getName();
        }
        catch (SigarException e) {
            primaryInterface = null;
        }
        HashMap<String, NetworkStats.Interface> interfaces = new HashMap<String, NetworkStats.Interface>();
        try {
            String[] netInterfaceList;
            for (String interfaceName : netInterfaceList = (String[])MoreObjects.firstNonNull((Object)sigar.getNetInterfaceList(), (Object)new String[0])) {
                NetInterfaceStat netInterfaceStat = sigar.getNetInterfaceStat(interfaceName);
                NetworkStats.InterfaceStats interfaceStats = NetworkStats.InterfaceStats.create(netInterfaceStat.getRxPackets(), netInterfaceStat.getRxErrors(), netInterfaceStat.getRxDropped(), netInterfaceStat.getRxOverruns(), netInterfaceStat.getRxFrame(), netInterfaceStat.getTxPackets(), netInterfaceStat.getTxErrors(), netInterfaceStat.getTxDropped(), netInterfaceStat.getTxOverruns(), netInterfaceStat.getTxCarrier(), netInterfaceStat.getTxCollisions(), netInterfaceStat.getRxBytes(), netInterfaceStat.getTxBytes());
                NetInterfaceConfig netInterfaceConfig = sigar.getNetInterfaceConfig(interfaceName);
                NetworkStats.Interface networkInterface = NetworkStats.Interface.create(netInterfaceConfig.getName(), Collections.singleton(netInterfaceConfig.getAddress()), netInterfaceConfig.getHwaddr(), netInterfaceConfig.getMtu(), interfaceStats);
                interfaces.put(interfaceName, networkInterface);
            }
        }
        catch (SigarException netInterfaceList) {
            // empty catch block
        }
        try {
            Tcp tcp = sigar.getTcp();
            tcpStats = NetworkStats.TcpStats.create(tcp.getActiveOpens(), tcp.getPassiveOpens(), tcp.getAttemptFails(), tcp.getEstabResets(), tcp.getCurrEstab(), tcp.getInSegs(), tcp.getOutSegs(), tcp.getRetransSegs(), tcp.getInErrs(), tcp.getOutRsts());
        }
        catch (SigarException e) {
            tcpStats = null;
        }
        return NetworkStats.create(primaryInterface, interfaces, tcpStats);
    }
}

