/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;
import org.graylog2.streams.StreamImpl;
import org.graylog2.streams.StreamRuleImpl;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.events.StreamsChangedEvent;

public class StreamRuleServiceImpl
extends PersistedServiceImpl
implements StreamRuleService {
    private final ClusterEventBus clusterEventBus;

    @Inject
    public StreamRuleServiceImpl(MongoConnection mongoConnection, ClusterEventBus clusterEventBus) {
        super(mongoConnection);
        this.collection(StreamRuleImpl.class).createIndex("stream_id");
        this.clusterEventBus = clusterEventBus;
    }

    @Override
    public StreamRule load(String id) throws NotFoundException {
        BasicDBObject o = (BasicDBObject)this.get(StreamRuleImpl.class, new ObjectId(id));
        if (o == null) {
            throw new NotFoundException("Couldn't find stream rule with ID" + id);
        }
        return new StreamRuleImpl((ObjectId)o.get("_id"), o.toMap());
    }

    @Override
    public List<StreamRule> loadForStream(Stream stream) {
        return this.loadForStreamId(stream.getId());
    }

    @Override
    public StreamRule create(Map<String, Object> data) {
        return new StreamRuleImpl(data);
    }

    @Override
    public StreamRule create(@Nullable String streamId, CreateStreamRuleRequest cr) {
        HashMap streamRuleData = Maps.newHashMap();
        streamRuleData.put("type", cr.type());
        streamRuleData.put("value", cr.value());
        streamRuleData.put("field", cr.field());
        streamRuleData.put("inverted", cr.inverted());
        streamRuleData.put("description", cr.description());
        if (streamId != null) {
            streamRuleData.put("stream_id", new ObjectId(streamId));
        }
        return new StreamRuleImpl(streamRuleData);
    }

    @Override
    public StreamRule copy(@Nullable String streamId, StreamRule streamRule) {
        HashMap streamRuleData = Maps.newHashMap();
        streamRuleData.put("type", streamRule.getType().toInteger());
        streamRuleData.put("value", streamRule.getValue());
        streamRuleData.put("field", streamRule.getField());
        streamRuleData.put("inverted", streamRule.getInverted());
        streamRuleData.put("description", streamRule.getDescription());
        if (streamId != null) {
            streamRuleData.put("stream_id", new ObjectId(streamId));
        }
        return new StreamRuleImpl(streamRuleData);
    }

    @Override
    public String save(StreamRule streamRule) throws ValidationException {
        String streamId = streamRule.getStreamId();
        String savedStreamRuleId = super.save(streamRule);
        this.clusterEventBus.post(StreamsChangedEvent.create(streamId));
        return savedStreamRuleId;
    }

    @Override
    public Set<String> save(Collection<StreamRule> streamRules) throws ValidationException {
        ImmutableSet.Builder streamIds = ImmutableSet.builder();
        ImmutableSet.Builder streamRuleIds = ImmutableSet.builder();
        for (StreamRule streamRule : streamRules) {
            String streamId = streamRule.getStreamId();
            String savedStreamRuleId = super.save(streamRule);
            streamIds.add((Object)streamId);
            streamRuleIds.add((Object)savedStreamRuleId);
        }
        this.clusterEventBus.post(StreamsChangedEvent.create((ImmutableSet<String>)streamIds.build()));
        return streamRuleIds.build();
    }

    @Override
    public int destroy(StreamRule streamRule) {
        String streamId = streamRule.getStreamId();
        int deletedStreamRules = super.destroy(streamRule);
        this.clusterEventBus.post(StreamsChangedEvent.create(streamId));
        return deletedStreamRules;
    }

    @Override
    public List<StreamRule> loadForStreamId(String streamId) {
        ObjectId id = new ObjectId(streamId);
        ArrayList<StreamRule> streamRules = new ArrayList<StreamRule>();
        List<DBObject> respStreamRules = this.query(StreamRuleImpl.class, (DBObject)new BasicDBObject("stream_id", (Object)id));
        for (DBObject streamRule : respStreamRules) {
            streamRules.add(this.toStreamRule(streamRule));
        }
        return streamRules;
    }

    @Override
    public Map<String, List<StreamRule>> loadForStreamIds(Collection<String> streamIds) {
        List objectIds = streamIds.stream().map(ObjectId::new).collect(Collectors.toList());
        List<DBObject> respStreamRules = this.query(StreamRuleImpl.class, (DBObject)new BasicDBObject("stream_id", (Object)new BasicDBObject("$in", objectIds)));
        return respStreamRules.stream().map(this::toStreamRule).collect(Collectors.groupingBy(StreamRule::getStreamId));
    }

    @Override
    public long totalStreamRuleCount() {
        return this.totalCount(StreamRuleImpl.class);
    }

    @Override
    public long streamRuleCount(String streamId) {
        return this.streamRuleCount(new ObjectId(streamId));
    }

    private long streamRuleCount(ObjectId streamId) {
        return this.count(StreamRuleImpl.class, (DBObject)new BasicDBObject("stream_id", (Object)streamId));
    }

    @Override
    public Map<String, Long> streamRuleCountByStream() {
        ImmutableMap.Builder streamRules = ImmutableMap.builder();
        try (DBCursor streamIds = this.collection(StreamImpl.class).find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("_id", (Object)1));){
            for (DBObject keys : streamIds) {
                ObjectId streamId = (ObjectId)keys.get("_id");
                streamRules.put((Object)streamId.toHexString(), (Object)this.streamRuleCount(streamId));
            }
        }
        return streamRules.build();
    }

    private StreamRule toStreamRule(DBObject dbObject) {
        Map fields = dbObject.toMap();
        return new StreamRuleImpl((ObjectId)dbObject.get("_id"), fields);
    }
}

