/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.graylog2.dashboards.events.DashboardDeletedEvent;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.events.StreamDeletedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPermissionsCleanupListener {
    private static final Logger LOG = LoggerFactory.getLogger(UserPermissionsCleanupListener.class);
    private final UserService userService;

    @Inject
    public UserPermissionsCleanupListener(EventBus serverEventBus, UserService userService) {
        this.userService = userService;
        serverEventBus.register((Object)this);
    }

    @Subscribe
    public void cleanupPermissionsOnDashboardRemoval(DashboardDeletedEvent event) {
        List<String> dashboardPermissions = Arrays.asList("dashboards:read:" + event.dashboardId(), "dashboards:edit:" + event.dashboardId());
        this.removePermissionsFromAllUsers(dashboardPermissions);
    }

    @Subscribe
    public void cleanupPermissionsOnStreamRemoval(StreamDeletedEvent event) {
        List<String> streamPermissions = Arrays.asList("streams:read:" + event.streamId(), "streams:edit:" + event.streamId(), "streams:changestate:" + event.streamId());
        this.removePermissionsFromAllUsers(streamPermissions);
    }

    private void removePermissionsFromAllUsers(Collection<String> permissions) {
        List<User> users = this.userService.loadAll();
        for (User user : users) {
            ArrayList<String> userPermissions = new ArrayList<String>(user.getPermissions());
            boolean modifiedUser = userPermissions.removeAll(permissions);
            if (!modifiedUser) continue;
            user.setPermissions(userPermissions);
            try {
                String userId = this.userService.save(user);
                LOG.debug("Successfully updated permissions of user <{}>: {}", (Object)userId, userPermissions);
            }
            catch (ValidationException e) {
                LOG.warn("Unable to save user while removing permissions of deleted dashboard: ", (Throwable)e);
            }
        }
    }
}

