/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.AccessTokenService;
import org.graylog2.security.InMemoryRolePermissionResolver;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.Roles;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleService;
import org.graylog2.users.UserImpl;
import org.graylog2.users.events.UserChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServiceImpl
extends PersistedServiceImpl
implements UserService {
    private static final Logger LOG = LoggerFactory.getLogger(UserServiceImpl.class);
    private final Configuration configuration;
    private final RoleService roleService;
    private final AccessTokenService accesstokenService;
    private final UserImpl.Factory userFactory;
    private final InMemoryRolePermissionResolver inMemoryRolePermissionResolver;
    private final EventBus serverEventBus;

    @Inject
    public UserServiceImpl(MongoConnection mongoConnection, Configuration configuration, RoleService roleService, AccessTokenService accessTokenService, UserImpl.Factory userFactory, InMemoryRolePermissionResolver inMemoryRolePermissionResolver, EventBus serverEventBus) {
        super(mongoConnection);
        this.configuration = configuration;
        this.roleService = roleService;
        this.accesstokenService = accessTokenService;
        this.userFactory = userFactory;
        this.inMemoryRolePermissionResolver = inMemoryRolePermissionResolver;
        this.serverEventBus = serverEventBus;
        this.collection(UserImpl.class).createIndex("roles");
    }

    @Override
    @Nullable
    public User load(String username) {
        LOG.debug("Loading user {}", (Object)username);
        if (this.configuration.getRootUsername().equals(username)) {
            LOG.debug("User {} is the built-in admin user", (Object)username);
            return this.userFactory.createLocalAdminUser(this.roleService.getAdminRoleObjectId());
        }
        BasicDBObject query = new BasicDBObject();
        query.put("username", (Object)username);
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            String msg = "There was more than one matching user for username " + username + ". This should never happen.";
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
        DBObject userObject = result.get(0);
        Object userId = userObject.get("_id");
        LOG.debug("Loaded user {}/{} from MongoDB", (Object)username, userId);
        return this.userFactory.create((ObjectId)userId, userObject.toMap());
    }

    @Override
    public int delete(String username) {
        LOG.debug("Deleting user(s) with username \"{}\"", (Object)username);
        DBObject query = BasicDBObjectBuilder.start((String)"username", (Object)username).get();
        int result = this.destroy(query, "users");
        if (result > 1) {
            LOG.warn("Removed {} users matching username \"{}\".", (Object)result, (Object)username);
        }
        this.accesstokenService.deleteAllForUser(username);
        return result;
    }

    @Override
    public User create() {
        return this.userFactory.create(Maps.newHashMap());
    }

    @Override
    public List<User> loadAll() {
        BasicDBObject query = new BasicDBObject();
        List<DBObject> result = this.query(UserImpl.class, (DBObject)query);
        ArrayList users = Lists.newArrayList();
        for (DBObject dbObject : result) {
            users.add(this.userFactory.create((ObjectId)dbObject.get("_id"), dbObject.toMap()));
        }
        return users;
    }

    @Override
    public <T extends Persisted> String save(T model) throws ValidationException {
        if (model instanceof UserImpl.LocalAdminUser) {
            throw new IllegalStateException("Cannot modify local root user, this is a bug.");
        }
        String userId = super.save(model);
        this.serverEventBus.post((Object)UserChangedEvent.create(userId));
        return userId;
    }

    @Override
    public User getAdminUser() {
        return this.userFactory.createLocalAdminUser(this.roleService.getAdminRoleObjectId());
    }

    @Override
    public long count() {
        return this.totalCount(UserImpl.class);
    }

    @Override
    public Collection<User> loadAllForRole(Role role) {
        String roleId = role.getId();
        DBObject query = BasicDBObjectBuilder.start((String)"roles", (Object)new ObjectId(roleId)).get();
        List<DBObject> result = this.query(UserImpl.class, query);
        if (result == null || result.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet users = Sets.newHashSetWithExpectedSize((int)result.size());
        for (DBObject dbObject : result) {
            users.add(this.userFactory.create((ObjectId)dbObject.get("_id"), dbObject.toMap()));
        }
        return users;
    }

    @Override
    public Set<String> getRoleNames(User user) {
        Map<String, Role> idMap;
        Set<String> roleIds = user.getRoleIds();
        if (roleIds.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            idMap = this.roleService.loadAllIdMap();
        }
        catch (NotFoundException e) {
            LOG.error("Unable to load role ID map. Using empty map.", (Throwable)e);
            idMap = Collections.emptyMap();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Collections2.transform(roleIds, (Function)Roles.roleIdToNameFunction(idMap)), (Predicate)Predicates.notNull()));
    }

    @Override
    public List<String> getPermissionsForUser(User user) {
        ImmutableSet.Builder permSet = ImmutableSet.builder().addAll(user.getPermissions()).addAll(this.getUserPermissionsFromRoles(user));
        return permSet.build().asList();
    }

    @Override
    public Set<String> getUserPermissionsFromRoles(User user) {
        ImmutableSet.Builder permSet = ImmutableSet.builder();
        for (String roleId : user.getRoleIds()) {
            permSet.addAll(this.inMemoryRolePermissionResolver.resolveStringPermission(roleId));
        }
        return permSet.build();
    }

    @Override
    public void dissociateAllUsersFromRole(Role role) {
        Collection<User> usersInRole = this.loadAllForRole(role);
        for (User user : usersInRole) {
            if (user.isLocalAdmin()) continue;
            HashSet roles = Sets.newHashSet(user.getRoleIds());
            roles.remove(role.getId());
            user.setRoleIds(roles);
            try {
                this.save(user);
            }
            catch (ValidationException e) {
                LOG.error("Unable to remove role {} from user {}", (Object)role.getName(), (Object)user);
            }
        }
    }
}

