/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;

public final class Graphs {
    private static final ImmutableGraph EMPTY_DIRECTED_GRAPH = ImmutableGraph.copyOf((Graph)GraphBuilder.directed().build());
    private static final ImmutableGraph EMPTY_UNDIRECTED_GRAPH = ImmutableGraph.copyOf((Graph)GraphBuilder.undirected().build());

    private Graphs() {
    }

    public static <N> ImmutableGraph<N> emptyDirectedGraph() {
        return EMPTY_DIRECTED_GRAPH;
    }

    public static <N> ImmutableGraph<N> emptyUndirectedGraph() {
        return EMPTY_UNDIRECTED_GRAPH;
    }

    public static <N> ImmutableGraph<N> emptyGraph(Graph<N> graph) {
        return ImmutableGraph.copyOf((Graph)GraphBuilder.from(graph).build());
    }

    public static <N> ImmutableGraph<N> singletonDirectedGraph(N node) {
        MutableGraph graph = GraphBuilder.directed().build();
        graph.addNode(node);
        return ImmutableGraph.copyOf((Graph)graph);
    }

    public static <N> ImmutableGraph<N> singletonUndirectedGraph(N node) {
        MutableGraph graph = GraphBuilder.undirected().build();
        graph.addNode(node);
        return ImmutableGraph.copyOf((Graph)graph);
    }

    public static <N> ImmutableGraph<N> singletonGraph(Graph<N> graph, N node) {
        MutableGraph mutableGraph = GraphBuilder.from(graph).build();
        mutableGraph.addNode(node);
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    public static <N> void merge(MutableGraph<N> graph1, Graph<N> graph2) {
        for (Object node : graph2.nodes()) {
            graph1.addNode(node);
        }
        for (EndpointPair edge : graph2.edges()) {
            graph1.putEdge(edge.nodeU(), edge.nodeV());
        }
    }
}

