/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.base.Strings;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog2.indexer.results.TermsHistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.rest.models.search.responses.TermsResult;
import org.graylog2.rest.models.search.responses.TimeRange;
import org.joda.time.Duration;

public class SearchUtils {
    public static boolean validateInterval(String interval) {
        try {
            Searches.DateHistogramInterval.valueOf(interval);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static Searches.DateHistogramInterval buildInterval(@Nullable String intervalParam, org.graylog2.plugin.indexer.searches.timeranges.TimeRange timeRange) {
        if (!Strings.isNullOrEmpty((String)intervalParam)) {
            String interval = intervalParam.toUpperCase(Locale.ENGLISH);
            if (!SearchUtils.validateInterval(interval)) {
                throw new IllegalArgumentException("Invalid interval: \"" + interval + "\"");
            }
            return Searches.DateHistogramInterval.valueOf(interval);
        }
        Duration duration = Duration.millis((long)(timeRange.getTo().getMillis() - timeRange.getFrom().getMillis()));
        if (duration.getStandardHours() < 12L) {
            return Searches.DateHistogramInterval.MINUTE;
        }
        if (duration.getStandardDays() < 3L) {
            return Searches.DateHistogramInterval.HOUR;
        }
        if (duration.getStandardDays() < 30L) {
            return Searches.DateHistogramInterval.DAY;
        }
        if (duration.getStandardDays() < 60L) {
            return Searches.DateHistogramInterval.WEEK;
        }
        if (duration.getStandardDays() < 540L) {
            return Searches.DateHistogramInterval.MONTH;
        }
        if (duration.getStandardDays() < 1095L) {
            return Searches.DateHistogramInterval.QUARTER;
        }
        return Searches.DateHistogramInterval.YEAR;
    }

    public static org.graylog2.rest.models.search.responses.TermsHistogramResult buildTermsHistogramResult(TermsHistogramResult termsHistogram) {
        AbsoluteRange histogramBoundaries = termsHistogram.getHistogramBoundaries();
        Map<Long, TermsResult> result = termsHistogram.getResults().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            org.graylog2.indexer.results.TermsResult tr = (org.graylog2.indexer.results.TermsResult)entry.getValue();
            return TermsResult.create(tr.tookMs(), tr.getTerms(), tr.termsMapping(), tr.getMissing(), tr.getOther(), tr.getTotal(), tr.getBuiltQuery());
        }));
        return org.graylog2.rest.models.search.responses.TermsHistogramResult.create(termsHistogram.tookMs(), termsHistogram.getInterval().toString().toLowerCase(Locale.ENGLISH), termsHistogram.getSize(), result, termsHistogram.getTerms(), termsHistogram.getBuiltQuery(), TimeRange.create(histogramBoundaries.getFrom(), histogramBoundaries.getTo()));
    }
}

