/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.indices;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.Index;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventWithContext;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MoreIndices {
    private static final Logger LOG = LoggerFactory.getLogger(MoreIndices.class);
    private final JestClient jestClient;
    private final ObjectMapper objectMapper;
    private final StreamService streamService;

    @Inject
    public MoreIndices(JestClient jestClient, ObjectMapper objectMapper, StreamService streamService) {
        this.jestClient = jestClient;
        this.objectMapper = objectMapper;
        this.streamService = streamService;
    }

    public void bulkIndex(List<EventWithContext> eventsWithContext) {
        if (eventsWithContext.isEmpty()) {
            return;
        }
        Set<String> streamIds = eventsWithContext.stream().map(EventWithContext::event).flatMap(event -> event.getStreams().stream()).collect(Collectors.toSet());
        Map<String, String> streamIndices = this.streamService.loadByIds(streamIds).stream().collect(Collectors.toMap(Persisted::getId, stream -> stream.getIndexSet().getWriteIndexAlias()));
        Bulk.Builder bulk = new Bulk.Builder();
        for (EventWithContext eventWithContext : eventsWithContext) {
            Event event2 = eventWithContext.event();
            Map source = (Map)this.objectMapper.convertValue((Object)event2.toDto(), TypeReferences.MAP_STRING_OBJECT);
            source.put("timestamp", Tools.buildElasticSearchTimeFormat(Objects.requireNonNull(event2.getEventTimestamp()).withZone(DateTimeZone.UTC)));
            source.put("timestamp_processing", Tools.buildElasticSearchTimeFormat(Objects.requireNonNull(event2.getProcessingTimestamp()).withZone(DateTimeZone.UTC)));
            if (event2.getTimerangeStart() != null) {
                source.put("timerange_start", Tools.buildElasticSearchTimeFormat(event2.getTimerangeStart().withZone(DateTimeZone.UTC)));
            }
            if (event2.getTimerangeEnd() != null) {
                source.put("timerange_end", Tools.buildElasticSearchTimeFormat(event2.getTimerangeEnd().withZone(DateTimeZone.UTC)));
            }
            if (event2.getStreams().isEmpty()) {
                throw new IllegalStateException("Event streams cannot be empty");
            }
            Set indices = event2.getStreams().stream().map(streamId -> {
                String index = (String)streamIndices.get(streamId);
                if (index == null) {
                    LOG.warn("Couldn't find index set of stream <{}> for event <{}> (definition: {}/{})", new Object[]{streamId, event2.getId(), event2.getEventDefinitionType(), event2.getEventDefinitionId()});
                }
                return index;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            for (String index : indices) {
                bulk.addAction((BulkableAction)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)source).index(index)).type("message")).id(event2.getId())).build());
            }
        }
        try {
            BulkResult result = (BulkResult)this.jestClient.execute((Action)bulk.build());
            List failedItems = result.getFailedItems();
            if (!failedItems.isEmpty()) {
                LOG.error("Failed to index {} events: {}", (Object)eventsWithContext.size(), (Object)result.getErrorMessage());
            }
            LOG.debug("Index: Bulk indexed {} events, failures: {}", (Object)result.getItems().size(), (Object)failedItems.size());
        }
        catch (IOException e) {
            LOG.error("Failed to index {} events", (Object)eventsWithContext.size(), (Object)e);
        }
    }
}

