/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import org.graylog.events.contentpack.entities.EmailEventNotificationConfigEntity;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.events.notifications.types.AutoValue_EmailEventNotificationConfig;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;

@JsonTypeName(value="email-notification-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EmailEventNotificationConfig
implements EventNotificationConfig {
    public static final String TYPE_NAME = "email-notification-v1";
    private static final String DEFAULT_SENDER = "graylog@example.org";
    static final String DEFAULT_SUBJECT = "Graylog event notification: ${event_definition_title}";
    static final String DEFAULT_BODY_TEMPLATE = "--- [Event Definition] ---------------------------\nTitle:       ${event_definition_title}\nDescription: ${event_definition_description}\nType:        ${event_definition_type}\n--- [Event] --------------------------------------\nTimestamp:            ${event.timestamp}\nMessage:              ${event.message}\nSource:               ${event.source}\nKey:                  ${event.key}\nPriority:             ${event.priority}\nAlert:                ${event.alert}\nTimestamp Processing: ${event.timestamp}\nTimerange Start:      ${event.timerange_start}\nTimerange End:        ${event.timerange_end}\nSource Streams:       ${event.source_streams}\nFields:\n${foreach event.fields field}  ${field.key}: ${field.value}\n${end}\n${if backlog}\n--- [Backlog] ------------------------------------\nLast messages accounting for this alert:\n${foreach backlog message}\n${message}\n\n${end}\n${end}\n\n";
    private static final String FIELD_SENDER = "sender";
    private static final String FIELD_SUBJECT = "subject";
    private static final String FIELD_BODY_TEMPLATE = "body_template";
    private static final String FIELD_EMAIL_RECIPIENTS = "email_recipients";
    private static final String FIELD_USER_RECIPIENTS = "user_recipients";

    @JsonProperty(value="sender")
    @NotBlank
    public abstract String sender();

    @JsonProperty(value="subject")
    @NotBlank
    public abstract String subject();

    @JsonProperty(value="body_template")
    @NotBlank
    public abstract String bodyTemplate();

    @JsonProperty(value="email_recipients")
    public abstract Set<String> emailRecipients();

    @JsonProperty(value="user_recipients")
    public abstract Set<String> userRecipients();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.sender().isEmpty()) {
            validation.addError(FIELD_SENDER, "Email Notification sender cannot be empty.");
        }
        if (this.subject().isEmpty()) {
            validation.addError(FIELD_SUBJECT, "Email Notification subject cannot be empty.");
        }
        if (this.bodyTemplate().isEmpty()) {
            validation.addError(FIELD_BODY_TEMPLATE, "Email Notification body template cannot be empty.");
        }
        if (this.emailRecipients().isEmpty() && this.userRecipients().isEmpty()) {
            validation.addError("recipients", "Email Notification must have email recipients or user recipients.");
        }
        return validation;
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return EmailEventNotificationConfigEntity.builder().sender(ValueReference.of(this.sender())).subject(ValueReference.of(this.subject())).bodyTemplate(ValueReference.of(this.bodyTemplate())).emailRecipients(this.emailRecipients()).userRecipients(this.userRecipients()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EmailEventNotificationConfig.Builder().type(EmailEventNotificationConfig.TYPE_NAME).sender(EmailEventNotificationConfig.DEFAULT_SENDER).subject(EmailEventNotificationConfig.DEFAULT_SUBJECT).emailRecipients((Set<String>)ImmutableSet.of()).userRecipients((Set<String>)ImmutableSet.of()).bodyTemplate(EmailEventNotificationConfig.DEFAULT_BODY_TEMPLATE);
        }

        @JsonProperty(value="sender")
        public abstract Builder sender(String var1);

        @JsonProperty(value="subject")
        public abstract Builder subject(String var1);

        @JsonProperty(value="body_template")
        public abstract Builder bodyTemplate(String var1);

        @JsonProperty(value="email_recipients")
        public abstract Builder emailRecipients(Set<String> var1);

        @JsonProperty(value="user_recipients")
        public abstract Builder userRecipients(Set<String> var1);

        public abstract EmailEventNotificationConfig build();
    }
}

