/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.freeenterprise;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import okhttp3.OkHttpClient;
import org.graylog.freeenterprise.FreeLicenseAPIClient;
import org.graylog.freeenterprise.FreeLicenseAPIRequest;
import org.graylog.freeenterprise.FreeLicenseAPIResponse;
import org.graylog.freeenterprise.FreeLicenseInfo;
import org.graylog.freeenterprise.FreeLicenseRequest;
import org.graylog.freeenterprise.FreeLicenseRequestException;
import org.graylog.freeenterprise.StagedFreeEnterpriseLicense;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class FreeEnterpriseService {
    private static final Logger LOG = LoggerFactory.getLogger(FreeEnterpriseService.class);
    private final FreeLicenseAPIClient apiClient;
    private final EventBus eventBus;
    private final ClusterConfigService clusterConfigService;
    private final MongoConnection mongoConnection;

    @Inject
    public FreeEnterpriseService(OkHttpClient httpClient, ObjectMapper objectMapper, EventBus eventBus, ClusterConfigService clusterConfigService, MongoConnection mongoConnection, @Named(value="free_enterprise_service_url") URI serviceUrl) {
        this.eventBus = eventBus;
        this.clusterConfigService = clusterConfigService;
        this.mongoConnection = mongoConnection;
        Retrofit retrofit = new Retrofit.Builder().baseUrl(serviceUrl.toString()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).client(httpClient).build();
        this.apiClient = (FreeLicenseAPIClient)retrofit.create(FreeLicenseAPIClient.class);
    }

    private boolean hasFreeLicenseStaged() {
        return this.clusterConfigService.get(StagedFreeEnterpriseLicense.class) != null;
    }

    private boolean hasLicenseInstalled() {
        return this.mongoConnection.getMongoDatabase().getCollection("licenses").countDocuments() > 0L;
    }

    private String getClusterId() {
        ClusterId clusterId = this.clusterConfigService.get(ClusterId.class);
        if (clusterId == null) {
            throw new IllegalStateException("Couldn't find cluster ID in cluster config");
        }
        return clusterId.clusterId();
    }

    public FreeLicenseInfo licenseInfo() {
        if (this.hasLicenseInstalled()) {
            return FreeLicenseInfo.installed();
        }
        if (this.hasFreeLicenseStaged()) {
            return FreeLicenseInfo.staged();
        }
        return FreeLicenseInfo.absent();
    }

    public boolean canRequestFreeLicense() {
        return !this.hasFreeLicenseStaged() && !this.hasLicenseInstalled();
    }

    public void requestFreeLicense(FreeLicenseRequest request) {
        String clusterId = this.getClusterId();
        FreeLicenseAPIRequest apiRequest = FreeLicenseAPIRequest.builder().clusterId(clusterId).firstName(request.firstName()).lastName(request.lastName()).email(request.email()).company(request.company()).build();
        try {
            Response response = this.apiClient.requestFreeLicense(apiRequest).execute();
            if (!response.isSuccessful() || response.body() == null) {
                if (response.errorBody() != null) {
                    LOG.error("Couldn't request free Graylog Enterprise license: {} (code={})", (Object)response.errorBody().string(), (Object)response.code());
                } else {
                    LOG.error("Couldn't request free Graylog Enterprise license: {} (code={}, message=\"{}\")", new Object[]{response.message(), response.code(), response.message()});
                }
                throw new FreeLicenseRequestException("Couldn't request free Graylog Enterprise license", request);
            }
            LOG.debug("Received free Graylog Enterprise license: {}", response.body());
            StagedFreeEnterpriseLicense dto = StagedFreeEnterpriseLicense.builder().clusterId(clusterId).license(((FreeLicenseAPIResponse)response.body()).licenseString()).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).build();
            this.clusterConfigService.write(dto);
            this.eventBus.post((Object)dto);
        }
        catch (FreeLicenseRequestException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error("Couldn't request free Graylog Enterprise license from remote service", (Throwable)e);
            throw new FreeLicenseRequestException("Couldn't request free Graylog Enterprise license from remote service", request, e);
        }
        catch (Exception e) {
            LOG.error("Couldn't request free Graylog Enterprise license", (Throwable)e);
            throw new FreeLicenseRequestException("Couldn't request free Graylog Enterprise license", request, e);
        }
    }
}

