/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.mina.util.IdentityHashSet;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.Stage;
import org.graylog.plugins.pipelineprocessor.ast.exceptions.PrecomputeFailure;
import org.graylog.plugins.pipelineprocessor.ast.expressions.AdditionExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.AndExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.ArrayLiteralExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BinaryExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BooleanExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BooleanValuedFunctionWrapper;
import org.graylog.plugins.pipelineprocessor.ast.expressions.ComparisonExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.DoubleExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.EqualityExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FieldAccessExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FieldRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.FunctionExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.IndexedAccessExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LogicalExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LongExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MapLiteralExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MessageRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.MultiplicationExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.NotExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.OrExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.SignedExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.StringExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.VarRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.statements.FunctionStatement;
import org.graylog.plugins.pipelineprocessor.ast.statements.Statement;
import org.graylog.plugins.pipelineprocessor.ast.statements.VarAssignStatement;
import org.graylog.plugins.pipelineprocessor.codegen.CodeGenerator;
import org.graylog.plugins.pipelineprocessor.codegen.GeneratedRule;
import org.graylog.plugins.pipelineprocessor.codegen.PipelineClassloader;
import org.graylog.plugins.pipelineprocessor.parser.FunctionRegistry;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.RuleLangBaseListener;
import org.graylog.plugins.pipelineprocessor.parser.RuleLangLexer;
import org.graylog.plugins.pipelineprocessor.parser.RuleLangParser;
import org.graylog.plugins.pipelineprocessor.parser.errors.IncompatibleArgumentType;
import org.graylog.plugins.pipelineprocessor.parser.errors.IncompatibleIndexType;
import org.graylog.plugins.pipelineprocessor.parser.errors.IncompatibleType;
import org.graylog.plugins.pipelineprocessor.parser.errors.IncompatibleTypes;
import org.graylog.plugins.pipelineprocessor.parser.errors.InvalidFunctionArgument;
import org.graylog.plugins.pipelineprocessor.parser.errors.InvalidOperation;
import org.graylog.plugins.pipelineprocessor.parser.errors.MissingRequiredParam;
import org.graylog.plugins.pipelineprocessor.parser.errors.NonIndexableType;
import org.graylog.plugins.pipelineprocessor.parser.errors.OptionalParametersMustBeNamed;
import org.graylog.plugins.pipelineprocessor.parser.errors.ParseError;
import org.graylog.plugins.pipelineprocessor.parser.errors.SyntaxError;
import org.graylog.plugins.pipelineprocessor.parser.errors.UndeclaredFunction;
import org.graylog.plugins.pipelineprocessor.parser.errors.UndeclaredVariable;
import org.graylog.plugins.pipelineprocessor.parser.errors.WrongNumberOfArgs;
import org.graylog.plugins.pipelineprocessor.processors.ConfigurationStateUpdater;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineRuleParser {
    private final FunctionRegistry functionRegistry;
    private final CodeGenerator codeGenerator;
    private static AtomicLong uniqueId = new AtomicLong(0L);
    private static final Logger log = LoggerFactory.getLogger(PipelineRuleParser.class);
    public static final ParseTreeWalker WALKER = ParseTreeWalker.DEFAULT;

    @Inject
    public PipelineRuleParser(FunctionRegistry functionRegistry, CodeGenerator codeGenerator) {
        this.functionRegistry = functionRegistry;
        this.codeGenerator = codeGenerator;
    }

    public Rule parseRule(String rule, boolean silent) throws ParseException {
        return this.parseRule(rule, silent, null);
    }

    public Rule parseRule(String rule, boolean silent, PipelineClassloader classLoader) throws ParseException {
        return this.parseRule("dummy" + uniqueId.getAndIncrement(), rule, silent, classLoader);
    }

    public Rule parseRule(String id, String rule, boolean silent) throws ParseException {
        return this.parseRule(id, rule, silent, null);
    }

    public Rule parseRule(String id, String rule, boolean silent, PipelineClassloader ruleClassLoader) throws ParseException {
        ParseContext parseContext = new ParseContext(silent);
        SyntaxErrorListener errorListener = new SyntaxErrorListener(parseContext);
        RuleLangLexer lexer = new RuleLangLexer((CharStream)new ANTLRInputStream(rule));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        RuleLangParser parser = new RuleLangParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        RuleLangParser.RuleDeclarationContext ruleDeclaration = parser.ruleDeclaration();
        WALKER.walk((ParseTreeListener)new RuleAstBuilder(parseContext), (ParseTree)ruleDeclaration);
        WALKER.walk((ParseTreeListener)new RuleTypeAnnotator(parseContext), (ParseTree)ruleDeclaration);
        WALKER.walk((ParseTreeListener)new RuleTypeChecker(parseContext), (ParseTree)ruleDeclaration);
        if (parseContext.getErrors().isEmpty()) {
            Rule parsedRule = parseContext.getRules().get(0).withId(id);
            if (ruleClassLoader != null && ConfigurationStateUpdater.isAllowCodeGeneration()) {
                try {
                    Class<? extends GeneratedRule> generatedClass = this.codeGenerator.generateCompiledRule(parsedRule, ruleClassLoader);
                    if (generatedClass != null) {
                        parsedRule = parsedRule.toBuilder().generatedRuleClass(generatedClass).build();
                    }
                }
                catch (Exception e) {
                    log.warn("Unable to compile rule {} to native code, falling back to interpreting it: {}", (Object)parsedRule.name(), (Object)e.getMessage());
                }
            }
            return parsedRule;
        }
        throw new ParseException(parseContext.getErrors());
    }

    public List<Pipeline> parsePipelines(String pipelines) throws ParseException {
        ParseContext parseContext = new ParseContext(false);
        SyntaxErrorListener errorListener = new SyntaxErrorListener(parseContext);
        RuleLangLexer lexer = new RuleLangLexer((CharStream)new ANTLRInputStream(pipelines));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        RuleLangParser parser = new RuleLangParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        RuleLangParser.PipelineDeclsContext pipelineDeclsContext = parser.pipelineDecls();
        WALKER.walk((ParseTreeListener)new PipelineAstBuilder(parseContext), (ParseTree)pipelineDeclsContext);
        if (parseContext.getErrors().isEmpty()) {
            return parseContext.pipelines;
        }
        throw new ParseException(parseContext.getErrors());
    }

    public Pipeline parsePipeline(String id, String source) {
        ParseContext parseContext = new ParseContext(false);
        SyntaxErrorListener errorListener = new SyntaxErrorListener(parseContext);
        RuleLangLexer lexer = new RuleLangLexer((CharStream)new ANTLRInputStream(source));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        RuleLangParser parser = new RuleLangParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        RuleLangParser.PipelineContext pipelineContext = parser.pipeline();
        WALKER.walk((ParseTreeListener)new PipelineAstBuilder(parseContext), (ParseTree)pipelineContext);
        if (parseContext.getErrors().isEmpty()) {
            Pipeline pipeline = parseContext.pipelines.get(0);
            return pipeline.withId(id);
        }
        throw new ParseException(parseContext.getErrors());
    }

    public static String unquote(String string, char quoteChar) {
        if (string.length() >= 2 && string.charAt(0) == quoteChar && string.charAt(string.length() - 1) == quoteChar) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String unescape(String string) {
        return StringEscapeUtils.unescapeJava((String)string);
    }

    private static class PipelineAstBuilder
    extends RuleLangBaseListener {
        private final ParseContext parseContext;

        public PipelineAstBuilder(ParseContext parseContext) {
            this.parseContext = parseContext;
        }

        @Override
        public void exitPipelineDeclaration(RuleLangParser.PipelineDeclarationContext ctx) {
            Pipeline.Builder builder = Pipeline.builder();
            builder.name(PipelineRuleParser.unquote(ctx.name.getText(), '\"'));
            ImmutableSortedSet.Builder stages = ImmutableSortedSet.orderedBy(Comparator.comparingInt(Stage::stage));
            for (RuleLangParser.StageDeclarationContext stage : ctx.stageDeclaration()) {
                Stage.Builder stageBuilder = Stage.builder();
                Token stageToken = stage.stage;
                if (stageToken == null) {
                    this.parseContext.addError(new SyntaxError(null, 0, 0, "", null));
                    return;
                }
                int stageNumber = Integer.parseInt(stageToken.getText());
                stageBuilder.stage(stageNumber);
                Token modifier = stage.modifier;
                if (modifier == null) {
                    this.parseContext.addError(new SyntaxError(null, stageToken.getLine(), stageToken.getCharPositionInLine(), "", null));
                    return;
                }
                boolean isAllModifier = modifier.getText().equalsIgnoreCase("all");
                stageBuilder.matchAll(isAllModifier);
                List<String> ruleRefs = stage.ruleRef().stream().map(ruleRefContext -> {
                    Token name = ruleRefContext.name;
                    if (name == null) {
                        Token symbol = ruleRefContext.Rule().getSymbol();
                        this.parseContext.addError(new SyntaxError(symbol, symbol.getLine(), symbol.getCharPositionInLine(), "invalid rule reference", null));
                        return "__illegal_reference";
                    }
                    return PipelineRuleParser.unquote(name.getText(), '\"');
                }).collect(Collectors.toList());
                stageBuilder.ruleReferences(ruleRefs);
                stages.add((Object)stageBuilder.build());
            }
            builder.stages((SortedSet<Stage>)stages.build());
            this.parseContext.pipelines.add(builder.build());
        }

        @Override
        public void exitInteger(RuleLangParser.IntegerContext ctx) {
            LongExpression expr = new LongExpression(ctx.getStart(), Long.parseLong(ctx.getText()));
            log.trace("INT: ctx {} => {}", (Object)ctx, (Object)expr);
            this.parseContext.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitString(RuleLangParser.StringContext ctx) {
            String text = PipelineRuleParser.unescape(PipelineRuleParser.unquote(ctx.getText(), '\"'));
            StringExpression expr = new StringExpression(ctx.getStart(), text);
            log.trace("STRING: ctx {} => {}", (Object)ctx, (Object)expr);
            this.parseContext.exprs.put((ParseTree)ctx, (Object)expr);
        }
    }

    private static class ParseContext {
        private final ParseTreeProperty<Expression> exprs = new ParseTreeProperty();
        private final ParseTreeProperty<Map<String, Expression>> args = new ParseTreeProperty();
        private final boolean silent;
        private ParseTreeProperty<List<Expression>> argsLists = new ParseTreeProperty();
        private Set<ParseError> errors = Sets.newHashSet();
        private Set<RuleContext> innerNodes = new IdentityHashSet();
        public List<Statement> statements = Lists.newArrayList();
        public List<Rule> rules = Lists.newArrayList();
        private Map<String, Expression> varDecls = Maps.newHashMap();
        public List<Pipeline> pipelines = Lists.newArrayList();

        public ParseContext(boolean silent) {
            this.silent = silent;
        }

        public ParseTreeProperty<Expression> expressions() {
            return this.exprs;
        }

        public ParseTreeProperty<Map<String, Expression>> arguments() {
            return this.args;
        }

        public List<Rule> getRules() {
            return this.rules;
        }

        public void setRules(List<Rule> rules) {
            this.rules = rules;
        }

        public void addRule(Rule rule) {
            this.rules.add(rule);
        }

        public List<Pipeline> getPipelines() {
            return this.pipelines;
        }

        public Set<ParseError> getErrors() {
            return this.errors;
        }

        public void addError(ParseError error) {
            this.errors.add(error);
        }

        public void addInnerNode(RuleContext node) {
            this.innerNodes.add(node);
        }

        public boolean isInnerNode(RuleContext node) {
            return this.innerNodes.contains(node);
        }

        public boolean defineVar(String name, Expression expr) {
            return this.varDecls.put(name, expr) == null;
        }

        public Expression getDefinedVar(String name) {
            return this.varDecls.get(name);
        }

        public ParseTreeProperty<List<Expression>> argumentLists() {
            return this.argsLists;
        }

        public boolean isSilent() {
            return this.silent;
        }
    }

    private static class RuleTypeChecker
    extends RuleLangBaseListener {
        private final ParseContext parseContext;
        StringBuffer sb = new StringBuffer();

        public RuleTypeChecker(ParseContext parseContext) {
            this.parseContext = parseContext;
        }

        @Override
        public void exitRuleDeclaration(RuleLangParser.RuleDeclarationContext ctx) {
            log.trace("Type tree {}", (Object)this.sb.toString());
        }

        @Override
        public void exitAnd(RuleLangParser.AndContext ctx) {
            this.checkBinaryExpression(ctx);
        }

        @Override
        public void exitOr(RuleLangParser.OrContext ctx) {
            this.checkBinaryExpression(ctx);
        }

        @Override
        public void exitComparison(RuleLangParser.ComparisonContext ctx) {
            this.checkBinaryExpression(ctx);
        }

        @Override
        public void exitAddition(RuleLangParser.AdditionContext ctx) {
            AdditionExpression addExpression = (AdditionExpression)this.parseContext.expressions().get((ParseTree)ctx);
            Class leftType = addExpression.left().getType();
            Class rightType = addExpression.right().getType();
            boolean leftDate = DateTime.class.equals((Object)leftType);
            boolean rightDate = DateTime.class.equals((Object)rightType);
            boolean leftPeriod = Period.class.equals((Object)leftType);
            boolean rightPeriod = Period.class.equals((Object)rightType);
            boolean leftString = String.class.equals((Object)leftType);
            boolean rightString = String.class.equals((Object)rightType);
            if (leftDate && rightDate) {
                if (addExpression.isPlus()) {
                    this.parseContext.addError(new InvalidOperation(ctx, addExpression, "Unable to add two dates"));
                }
                return;
            }
            if (leftDate && rightPeriod || leftPeriod && rightDate || leftPeriod && rightPeriod) {
                return;
            }
            if (leftString && rightString) {
                if (!addExpression.isPlus()) {
                    this.parseContext.addError(new InvalidOperation(ctx, addExpression, "Unable to subtract two strings"));
                }
                return;
            }
            this.checkBinaryExpression(ctx);
        }

        @Override
        public void exitMultiplication(RuleLangParser.MultiplicationContext ctx) {
            this.checkBinaryExpression(ctx);
        }

        @Override
        public void exitEquality(RuleLangParser.EqualityContext ctx) {
        }

        private void checkBinaryExpression(RuleLangParser.ExpressionContext ctx) {
            Class rightType;
            BinaryExpression binaryExpr = (BinaryExpression)this.parseContext.expressions().get((ParseTree)ctx);
            Class leftType = binaryExpr.left().getType();
            if (!leftType.equals(rightType = binaryExpr.right().getType()) || Void.class.equals((Object)leftType) || Void.class.equals((Object)rightType)) {
                this.parseContext.addError(new IncompatibleTypes(ctx, binaryExpr));
            }
        }

        @Override
        public void exitFunctionCall(RuleLangParser.FunctionCallContext ctx) {
            FunctionExpression expr = (FunctionExpression)this.parseContext.expressions().get((ParseTree)ctx);
            FunctionDescriptor<?> descriptor = expr.getFunction().descriptor();
            FunctionArgs args = expr.getArgs();
            for (ParameterDescriptor p : descriptor.params()) {
                Expression argExpr = args.expression(p.name());
                if (argExpr == null || p.type().isAssignableFrom(argExpr.getType())) continue;
                this.parseContext.addError(new IncompatibleArgumentType(ctx, expr, p, argExpr));
            }
        }

        @Override
        public void exitMessageRef(RuleLangParser.MessageRefContext ctx) {
            MessageRefExpression expr = (MessageRefExpression)this.parseContext.expressions().get((ParseTree)ctx);
            if (!expr.getFieldExpr().getType().equals(String.class)) {
                this.parseContext.addError(new IncompatibleType(ctx, String.class, expr.getFieldExpr().getType()));
            }
        }

        @Override
        public void enterEveryRule(ParserRuleContext ctx) {
            Expression expression = (Expression)this.parseContext.expressions().get((ParseTree)ctx);
            if (expression != null && !this.parseContext.isInnerNode((RuleContext)ctx)) {
                this.sb.append(" ( ");
                this.sb.append(expression.getClass().getSimpleName());
                this.sb.append(":").append(ctx.getClass().getSimpleName()).append(" ");
                this.sb.append(" <").append(expression.getType().getSimpleName()).append("> ");
                this.sb.append(ctx.getText());
            }
        }

        @Override
        public void exitEveryRule(ParserRuleContext ctx) {
            Expression expression = (Expression)this.parseContext.expressions().get((ParseTree)ctx);
            if (expression != null && !this.parseContext.isInnerNode((RuleContext)ctx)) {
                this.sb.append(" ) ");
            }
        }

        @Override
        public void exitIndexedAccess(RuleLangParser.IndexedAccessContext ctx) {
            IndexedAccessExpression idxExpr = (IndexedAccessExpression)this.parseContext.expressions().get((ParseTree)ctx);
            Class indexableType = idxExpr.getIndexableObject().getType();
            Class indexType = idxExpr.getIndex().getType();
            boolean isMap = Map.class.isAssignableFrom(indexableType);
            if (indexableType.isArray() || List.class.isAssignableFrom(indexableType) || Iterable.class.isAssignableFrom(indexableType) || isMap) {
                if (isMap) {
                    if (!String.class.equals((Object)indexType)) {
                        this.parseContext.addError(new IncompatibleIndexType(ctx, String.class, indexType));
                    }
                } else if (!Long.class.equals((Object)indexType)) {
                    this.parseContext.addError(new IncompatibleIndexType(ctx, Long.class, indexType));
                }
            } else {
                this.parseContext.addError(new NonIndexableType(ctx, indexableType));
            }
        }
    }

    private static class RuleTypeAnnotator
    extends RuleLangBaseListener {
        private final ParseContext parseContext;

        public RuleTypeAnnotator(ParseContext parseContext) {
            this.parseContext = parseContext;
        }

        @Override
        public void exitIdentifier(RuleLangParser.IdentifierContext ctx) {
            Expression expr = (Expression)this.parseContext.expressions().get((ParseTree)ctx);
            if (expr instanceof VarRefExpression) {
                VarRefExpression varRefExpression = (VarRefExpression)expr;
                String name = varRefExpression.varName();
                Expression expression = this.parseContext.getDefinedVar(name);
                if (expression == null) {
                    if (this.parseContext.isSilent()) {
                        log.debug("Unable to retrieve expression for variable {}, this is a bug", (Object)name);
                    } else {
                        log.error("Unable to retrieve expression for variable {}, this is a bug", (Object)name);
                    }
                    return;
                }
                log.trace("Inferred type of variable {} to {}", (Object)name, (Object)expression.getType().getSimpleName());
                varRefExpression.setType(expression.getType());
            }
        }

        @Override
        public void exitAddition(RuleLangParser.AdditionContext ctx) {
            Class rightType;
            AdditionExpression expr = (AdditionExpression)this.parseContext.expressions().get((ParseTree)ctx);
            Class leftType = expr.left().getType();
            if (leftType.equals(rightType = expr.right().getType())) {
                expr.setType(leftType);
            } else if (DateTime.class.equals((Object)leftType) && DateTime.class.equals((Object)rightType)) {
                expr.setType(Duration.class);
            } else if (DateTime.class.equals((Object)leftType) && Period.class.equals((Object)rightType) || Period.class.equals((Object)leftType) && DateTime.class.equals((Object)rightType)) {
                expr.setType(DateTime.class);
            } else {
                expr.setType(Void.class);
            }
        }

        @Override
        public void exitMultiplication(RuleLangParser.MultiplicationContext ctx) {
            Class rightType;
            MultiplicationExpression expr = (MultiplicationExpression)this.parseContext.expressions().get((ParseTree)ctx);
            Class leftType = expr.left().getType();
            if (leftType.equals(rightType = expr.right().getType())) {
                expr.setType(leftType);
            } else {
                expr.setType(Void.class);
            }
        }
    }

    private class RuleAstBuilder
    extends RuleLangBaseListener {
        private final ParseContext parseContext;
        private final ParseTreeProperty<Map<String, Expression>> args;
        private final ParseTreeProperty<List<Expression>> argsList;
        private final ParseTreeProperty<Expression> exprs;
        private final Set<String> definedVars = Sets.newHashSet();
        private ArrayDeque<Boolean> isIdIsFieldAccess = new ArrayDeque();

        public RuleAstBuilder(ParseContext parseContext) {
            this.parseContext = parseContext;
            this.args = parseContext.arguments();
            this.argsList = parseContext.argumentLists();
            this.exprs = parseContext.expressions();
            this.isIdIsFieldAccess.push(false);
        }

        @Override
        public void exitRuleDeclaration(RuleLangParser.RuleDeclarationContext ctx) {
            LogicalExpression condition;
            Rule.Builder ruleBuilder = Rule.builder();
            ruleBuilder.name(PipelineRuleParser.unquote(ctx.name == null ? "" : ctx.name.getText(), '\"'));
            Expression expr = (Expression)this.exprs.get((ParseTree)ctx.condition);
            if (expr instanceof LogicalExpression) {
                condition = (LogicalExpression)expr;
            } else if (expr != null && expr.getType().equals(Boolean.class)) {
                condition = new BooleanValuedFunctionWrapper(ctx.getStart(), expr);
            } else {
                condition = new BooleanExpression(ctx.getStart(), false);
                log.debug("Unable to create condition, replacing with 'false'");
            }
            ruleBuilder.when(condition);
            ruleBuilder.then(this.parseContext.statements);
            Rule rule = ruleBuilder.build();
            this.parseContext.addRule(rule);
            log.trace("Declaring rule {}", (Object)rule);
        }

        @Override
        public void exitFuncStmt(RuleLangParser.FuncStmtContext ctx) {
            Expression expr = (Expression)this.exprs.get((ParseTree)ctx.functionCall());
            FunctionStatement functionStatement = new FunctionStatement(expr);
            this.parseContext.statements.add(functionStatement);
        }

        @Override
        public void exitVarAssignStmt(RuleLangParser.VarAssignStmtContext ctx) {
            String name = PipelineRuleParser.unquote(ctx.varName.getText(), '`');
            Expression expr = (Expression)this.exprs.get((ParseTree)ctx.expression());
            this.parseContext.defineVar(name, expr);
            this.definedVars.add(name);
            this.parseContext.statements.add(new VarAssignStatement(name, expr));
        }

        @Override
        public void exitFunctionCall(RuleLangParser.FunctionCallContext ctx) {
            FunctionExpression expr;
            String name = ctx.funcName.getText();
            Map argsMap = (Map)this.args.get((ParseTree)ctx.arguments());
            List positionalArgs = (List)this.argsList.get((ParseTree)ctx.arguments());
            Function<?> function = PipelineRuleParser.this.functionRegistry.resolve(name);
            if (function == null) {
                this.parseContext.addError(new UndeclaredFunction(ctx));
            } else {
                ImmutableList<ParameterDescriptor> params = function.descriptor().params();
                boolean hasOptionalParams = params.stream().anyMatch(ParameterDescriptor::optional);
                if (argsMap != null) {
                    if (!hasOptionalParams && params.size() != argsMap.size()) {
                        this.parseContext.addError(new WrongNumberOfArgs(ctx, function, argsMap.size()));
                    } else {
                        Map givenArguments = argsMap;
                        List missingParams = params.stream().filter(p -> !p.optional()).map(p -> givenArguments.containsKey(p.name()) ? null : p).filter(Objects::nonNull).collect(Collectors.toList());
                        for (ParameterDescriptor param : missingParams) {
                            this.parseContext.addError(new MissingRequiredParam(ctx, function, param));
                        }
                    }
                } else if (positionalArgs != null) {
                    argsMap = Maps.newHashMap();
                    if (!hasOptionalParams && positionalArgs.size() != params.size()) {
                        this.parseContext.addError(new WrongNumberOfArgs(ctx, function, positionalArgs.size()));
                    }
                    boolean hasError = false;
                    if (hasOptionalParams) {
                        int firstOptional = Integer.MAX_VALUE;
                        boolean requiredAfterOptional = false;
                        int i = 0;
                        for (ParameterDescriptor param : params) {
                            ++i;
                            if (param.optional()) {
                                firstOptional = Math.min(firstOptional, i);
                                continue;
                            }
                            if (i <= firstOptional) continue;
                            requiredAfterOptional = true;
                        }
                        if (requiredAfterOptional) {
                            this.parseContext.addError(new OptionalParametersMustBeNamed(ctx, function));
                            hasError = true;
                        } else {
                            long numberRequiredParams = params.stream().filter(p -> !p.optional()).count();
                            if (numberRequiredParams > (long)positionalArgs.size()) {
                                this.parseContext.addError(new WrongNumberOfArgs(ctx, function, positionalArgs.size()));
                                hasError = true;
                            }
                        }
                    }
                    if (!hasError) {
                        int i = 0;
                        for (ParameterDescriptor p2 : params) {
                            if (i < positionalArgs.size()) {
                                Expression argExpr = (Expression)positionalArgs.get(i);
                                argsMap.put(p2.name(), argExpr);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (!params.stream().allMatch(ParameterDescriptor::optional)) {
                    this.parseContext.addError(new WrongNumberOfArgs(ctx, function, 0));
                }
            }
            try {
                expr = new FunctionExpression(ctx.getStart(), new FunctionArgs(PipelineRuleParser.this.functionRegistry.resolveOrError(name), argsMap));
            }
            catch (PrecomputeFailure precomputeFailure) {
                this.parseContext.addError(new InvalidFunctionArgument(ctx, function, precomputeFailure));
                expr = new FunctionExpression(ctx.getStart(), new FunctionArgs(Function.ERROR_FUNCTION, argsMap));
            }
            log.trace("FUNC: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitNamedArgs(RuleLangParser.NamedArgsContext ctx) {
            HashMap argMap = Maps.newHashMap();
            for (RuleLangParser.PropAssignmentContext propAssignmentContext : ctx.propAssignment()) {
                String argName = PipelineRuleParser.unquote(propAssignmentContext.Identifier().getText(), '`');
                Expression argValue = (Expression)this.exprs.get((ParseTree)propAssignmentContext.expression());
                argMap.put(argName, argValue);
            }
            this.args.put((ParseTree)ctx, (Object)argMap);
        }

        @Override
        public void exitPositionalArgs(RuleLangParser.PositionalArgsContext ctx) {
            ArrayList expressions = Lists.newArrayListWithCapacity((int)ctx.expression().size());
            expressions.addAll(ctx.expression().stream().map(arg_0 -> this.exprs.get(arg_0)).collect(Collectors.toList()));
            this.argsList.put((ParseTree)ctx, (Object)expressions);
        }

        @Override
        public void enterNested(RuleLangParser.NestedContext ctx) {
            this.isIdIsFieldAccess.push(true);
        }

        @Override
        public void exitNested(RuleLangParser.NestedContext ctx) {
            this.isIdIsFieldAccess.pop();
            Expression object = (Expression)this.exprs.get((ParseTree)ctx.fieldSet);
            Expression field = (Expression)this.exprs.get((ParseTree)ctx.field);
            FieldAccessExpression expr = new FieldAccessExpression(ctx.getStart(), object, field);
            log.trace("FIELDACCESS: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitNot(RuleLangParser.NotContext ctx) {
            Expression expression = this.upgradeBoolFunctionExpression(ctx.expression());
            NotExpression expr = new NotExpression(ctx.getStart(), expression);
            log.trace("NOT: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitAnd(RuleLangParser.AndContext ctx) {
            Expression left = this.upgradeBoolFunctionExpression(ctx.left);
            Expression right = this.upgradeBoolFunctionExpression(ctx.right);
            AndExpression expr = new AndExpression(ctx.getStart(), left, right);
            log.trace("AND: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        private Expression upgradeBoolFunctionExpression(RuleLangParser.ExpressionContext leftExprContext) {
            Expression leftExpr = (Expression)this.exprs.get((ParseTree)leftExprContext);
            if (leftExpr instanceof FunctionExpression && leftExpr.getType().equals(Boolean.class)) {
                leftExpr = new BooleanValuedFunctionWrapper(leftExprContext.getStart(), leftExpr);
            }
            return leftExpr;
        }

        @Override
        public void exitOr(RuleLangParser.OrContext ctx) {
            Expression left = this.upgradeBoolFunctionExpression(ctx.left);
            Expression right = this.upgradeBoolFunctionExpression(ctx.right);
            OrExpression expr = new OrExpression(ctx.getStart(), left, right);
            log.trace("OR: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitEquality(RuleLangParser.EqualityContext ctx) {
            Expression left = (Expression)this.exprs.get((ParseTree)ctx.left);
            Expression right = (Expression)this.exprs.get((ParseTree)ctx.right);
            boolean equals = ctx.equality.getText().equals("==");
            EqualityExpression expr = new EqualityExpression(ctx.getStart(), left, right, equals);
            log.trace("EQUAL: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitComparison(RuleLangParser.ComparisonContext ctx) {
            Expression left = (Expression)this.exprs.get((ParseTree)ctx.left);
            Expression right = (Expression)this.exprs.get((ParseTree)ctx.right);
            String operator = ctx.comparison.getText();
            ComparisonExpression expr = new ComparisonExpression(ctx.getStart(), left, right, operator);
            log.trace("COMPARE: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitInteger(RuleLangParser.IntegerContext ctx) {
            LongExpression expr = new LongExpression(ctx.getStart(), Long.parseLong(ctx.getText()));
            log.trace("INT: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitFloat(RuleLangParser.FloatContext ctx) {
            DoubleExpression expr = new DoubleExpression(ctx.getStart(), Double.parseDouble(ctx.getText()));
            log.trace("FLOAT: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitChar(RuleLangParser.CharContext ctx) {
            super.exitChar(ctx);
        }

        @Override
        public void exitString(RuleLangParser.StringContext ctx) {
            String text = PipelineRuleParser.unescape(PipelineRuleParser.unquote(ctx.getText(), '\"'));
            StringExpression expr = new StringExpression(ctx.getStart(), text);
            log.trace("STRING: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitBoolean(RuleLangParser.BooleanContext ctx) {
            BooleanExpression expr = new BooleanExpression(ctx.getStart(), Boolean.valueOf(ctx.getText()));
            log.trace("BOOL: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitLiteralPrimary(RuleLangParser.LiteralPrimaryContext ctx) {
            this.exprs.put((ParseTree)ctx, (Object)((Expression)this.exprs.get((ParseTree)ctx.literal())));
            this.parseContext.addInnerNode((RuleContext)ctx);
        }

        @Override
        public void exitArrayLiteralExpr(RuleLangParser.ArrayLiteralExprContext ctx) {
            List<Expression> elements = ctx.expression().stream().map(arg_0 -> this.exprs.get(arg_0)).collect(Collectors.toList());
            this.exprs.put((ParseTree)ctx, (Object)new ArrayLiteralExpression(ctx.getStart(), elements));
        }

        @Override
        public void exitMapLiteralExpr(RuleLangParser.MapLiteralExprContext ctx) {
            HashMap map = Maps.newHashMap();
            for (RuleLangParser.PropAssignmentContext propAssignmentContext : ctx.propAssignment()) {
                String key = PipelineRuleParser.unquote(propAssignmentContext.Identifier().getText(), '`');
                Expression value = (Expression)this.exprs.get((ParseTree)propAssignmentContext.expression());
                map.put(key, value);
            }
            this.exprs.put((ParseTree)ctx, (Object)new MapLiteralExpression(ctx.getStart(), map));
        }

        @Override
        public void exitParenExpr(RuleLangParser.ParenExprContext ctx) {
            this.exprs.put((ParseTree)ctx, (Object)((Expression)this.exprs.get((ParseTree)ctx.expression())));
            this.parseContext.addInnerNode((RuleContext)ctx);
        }

        @Override
        public void exitSignedExpression(RuleLangParser.SignedExpressionContext ctx) {
            Expression right = (Expression)this.exprs.get((ParseTree)ctx.expr);
            boolean isPlus = ctx.sign.getText().equals("+");
            SignedExpression expr = new SignedExpression(ctx.getStart(), right, isPlus);
            log.trace("SIGN: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitAddition(RuleLangParser.AdditionContext ctx) {
            Expression left = (Expression)this.exprs.get((ParseTree)ctx.left);
            Expression right = (Expression)this.exprs.get((ParseTree)ctx.right);
            boolean isPlus = ctx.add.getText().equals("+");
            AdditionExpression expr = new AdditionExpression(ctx.getStart(), left, right, isPlus);
            log.trace("ADD: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitMultiplication(RuleLangParser.MultiplicationContext ctx) {
            Expression left = (Expression)this.exprs.get((ParseTree)ctx.left);
            Expression right = (Expression)this.exprs.get((ParseTree)ctx.right);
            char operator = ctx.mult.getText().charAt(0);
            MultiplicationExpression expr = new MultiplicationExpression(ctx.getStart(), left, right, operator);
            log.trace("MULT: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void enterMessageRef(RuleLangParser.MessageRefContext ctx) {
            this.isIdIsFieldAccess.push(true);
        }

        @Override
        public void exitMessageRef(RuleLangParser.MessageRefContext ctx) {
            this.isIdIsFieldAccess.pop();
            Expression fieldExpr = (Expression)this.exprs.get((ParseTree)ctx.field);
            MessageRefExpression expr = new MessageRefExpression(ctx.getStart(), fieldExpr);
            log.trace("$MSG: ctx {} => {}", (Object)ctx, (Object)expr);
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitIdentifier(RuleLangParser.IdentifierContext ctx) {
            String type;
            BaseExpression expr;
            String identifierName = PipelineRuleParser.unquote(ctx.Identifier().getText(), '`');
            if (!this.isIdIsFieldAccess.peek().booleanValue() && !this.definedVars.contains(identifierName)) {
                this.parseContext.addError(new UndeclaredVariable(ctx));
            }
            if (this.isIdIsFieldAccess.peek().booleanValue() && !this.definedVars.contains(identifierName)) {
                expr = new FieldRefExpression(ctx.getStart(), identifierName, this.parseContext.getDefinedVar(identifierName));
                type = "FIELDREF";
            } else {
                expr = new VarRefExpression(ctx.getStart(), identifierName, this.parseContext.getDefinedVar(identifierName));
                type = "VARREF";
            }
            log.trace("{}: ctx {} => {}", new Object[]{type, ctx, expr});
            this.exprs.put((ParseTree)ctx, (Object)expr);
        }

        @Override
        public void exitFunc(RuleLangParser.FuncContext ctx) {
            this.exprs.put((ParseTree)ctx, (Object)((Expression)this.exprs.get((ParseTree)ctx.functionCall())));
            this.parseContext.addInnerNode((RuleContext)ctx);
        }

        @Override
        public void exitIndexedAccess(RuleLangParser.IndexedAccessContext ctx) {
            Expression array = (Expression)this.exprs.get((ParseTree)ctx.array);
            Expression index = (Expression)this.exprs.get((ParseTree)ctx.index);
            IndexedAccessExpression expr = new IndexedAccessExpression(ctx.getStart(), array, index);
            this.exprs.put((ParseTree)ctx, (Object)expr);
            log.trace("IDXACCESS: ctx {} => {}", (Object)ctx, (Object)expr);
        }
    }

    private static class SyntaxErrorListener
    extends BaseErrorListener {
        private final ParseContext parseContext;

        public SyntaxErrorListener(ParseContext parseContext) {
            this.parseContext = parseContext;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.parseContext.addError(new SyntaxError(offendingSymbol, line, charPositionInLine, msg, e));
        }
    }
}

