/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.Traverser;
import com.google.inject.name.Named;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.MultiSearch;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Provider;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryMetadata;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.ESQueryDecorators;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.elasticsearch.QueryStringParser;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.engine.QueryBackend;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog.plugins.views.search.errors.SearchTypeErrorParser;
import org.graylog.plugins.views.search.filter.QueryStringFilter;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchBackend
implements QueryBackend<ESGeneratedQueryContext> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchBackend.class);
    private final Map<String, Provider<ESSearchTypeHandler<? extends SearchType>>> elasticsearchSearchTypeHandlers;
    private final QueryStringParser queryStringParser;
    private final JestClient jestClient;
    private final IndexLookup indexLookup;
    private final ESQueryDecorators esQueryDecorators;
    private final ESGeneratedQueryContext.Factory queryContextFactory;
    private final boolean allowLeadingWildcard;

    @Inject
    public ElasticsearchBackend(Map<String, Provider<ESSearchTypeHandler<? extends SearchType>>> elasticsearchSearchTypeHandlers, QueryStringParser queryStringParser, JestClient jestClient, IndexLookup indexLookup, ESQueryDecorators esQueryDecorators, ESGeneratedQueryContext.Factory queryContextFactory, @Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcard) {
        this.elasticsearchSearchTypeHandlers = elasticsearchSearchTypeHandlers;
        this.queryStringParser = queryStringParser;
        this.jestClient = jestClient;
        this.indexLookup = indexLookup;
        this.esQueryDecorators = esQueryDecorators;
        this.queryContextFactory = queryContextFactory;
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    private QueryBuilder normalizeQueryString(String queryString) {
        return queryString.isEmpty() || queryString.trim().equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery((String)queryString).allowLeadingWildcard(Boolean.valueOf(this.allowLeadingWildcard));
    }

    @Override
    public ESGeneratedQueryContext generate(SearchJob job, Query query, Set<QueryResult> results) {
        ElasticsearchQueryString backendQuery = (ElasticsearchQueryString)query.query();
        ImmutableSet<SearchType> searchTypes = query.searchTypes();
        String queryString = this.esQueryDecorators.decorate(backendQuery.queryString(), job, query, results);
        QueryBuilder normalizedRootQuery = this.normalizeQueryString(queryString);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter(normalizedRootQuery);
        this.generateFilterClause(query.filter(), job, query, results).map(arg_0 -> ((BoolQueryBuilder)boolQuery).filter(arg_0));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQuery).from(0).size(0);
        ESGeneratedQueryContext queryContext = this.queryContextFactory.create(this, searchSourceBuilder, job, query, results);
        for (SearchType searchType : searchTypes) {
            SearchSourceBuilder searchTypeSourceBuilder = queryContext.searchSourceBuilder(searchType);
            Set<String> effectiveStreamIds = searchType.effectiveStreams().isEmpty() ? query.usedStreamIds() : searchType.effectiveStreams();
            BoolQueryBuilder searchTypeOverrides = QueryBuilders.boolQuery().must(searchTypeSourceBuilder.query()).must(Objects.requireNonNull(IndexHelper.getTimestampRangeFilter(query.effectiveTimeRange(searchType)), "Timerange for search type " + searchType.id() + " cannot be found in query or search type.")).must((QueryBuilder)QueryBuilders.termsQuery((String)"streams", effectiveStreamIds));
            searchType.query().ifPresent(q -> {
                ElasticsearchQueryString searchTypeBackendQuery = (ElasticsearchQueryString)q;
                String searchTypeQueryString = this.esQueryDecorators.decorate(searchTypeBackendQuery.queryString(), job, query, results);
                QueryBuilder normalizedSearchTypeQuery = this.normalizeQueryString(searchTypeQueryString);
                searchTypeOverrides.must(normalizedSearchTypeQuery);
            });
            searchTypeSourceBuilder.query((QueryBuilder)searchTypeOverrides);
            String type = searchType.type();
            Provider<ESSearchTypeHandler<? extends SearchType>> searchTypeHandler = this.elasticsearchSearchTypeHandlers.get(type);
            if (searchTypeHandler == null) {
                LOG.error("Unknown search type {} for elasticsearch backend, cannot generate query part. Skipping this search type.", (Object)type);
                queryContext.addError(new SearchTypeError(query, searchType.id(), "Unknown search type '" + type + "' for elasticsearch backend, cannot generate query"));
                continue;
            }
            ((ESSearchTypeHandler)searchTypeHandler.get()).generateQueryPart(job, query, searchType, queryContext);
        }
        return queryContext;
    }

    public Optional<QueryBuilder> generateFilterClause(Filter filter, SearchJob job, Query query, Set<QueryResult> results) {
        if (filter == null) {
            return Optional.empty();
        }
        switch (filter.type()) {
            case "and": {
                BoolQueryBuilder andBuilder = QueryBuilders.boolQuery();
                filter.filters().stream().map(filter1 -> this.generateFilterClause((Filter)filter1, job, query, results)).forEach(optQueryBuilder -> optQueryBuilder.ifPresent(arg_0 -> ((BoolQueryBuilder)andBuilder).must(arg_0)));
                return Optional.of(andBuilder);
            }
            case "or": {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                filter.filters().stream().map(filter1 -> this.generateFilterClause((Filter)filter1, job, query, results)).forEach(optQueryBuilder -> optQueryBuilder.ifPresent(arg_0 -> ((BoolQueryBuilder)orBuilder).should(arg_0)));
                return Optional.of(orBuilder);
            }
            case "stream": {
                return Optional.empty();
            }
            case "query_string": {
                return Optional.of(QueryBuilders.queryStringQuery((String)this.esQueryDecorators.decorate(((QueryStringFilter)filter).query(), job, query, results)));
            }
        }
        return Optional.empty();
    }

    @Override
    public QueryResult doRun(SearchJob job, Query query, ESGeneratedQueryContext queryContext, Set<QueryResult> predecessorResults) {
        if (query.searchTypes().isEmpty()) {
            return QueryResult.builder().query(query).searchTypes(Collections.emptyMap()).errors(new HashSet<SearchError>(queryContext.errors())).build();
        }
        LOG.debug("Running query {} for job {}", (Object)query.id(), (Object)job.getId());
        HashMap resultsMap = Maps.newHashMap();
        Set<String> affectedIndices = this.indexLookup.indexNamesForStreamsInTimeRange(query.usedStreamIds(), query.timerange());
        Map<String, SearchSourceBuilder> searchTypeQueries = queryContext.searchTypeQueries();
        ArrayList<String> searchTypeIds = new ArrayList<String>(searchTypeQueries.keySet());
        List searches = searchTypeIds.stream().map(searchTypeId -> {
            Set<String> affectedIndicesForSearchType = query.searchTypes().stream().filter(s -> s.id().equalsIgnoreCase((String)searchTypeId)).findFirst().flatMap(searchType -> {
                if (searchType.effectiveStreams().isEmpty() && !query.globalOverride().flatMap(GlobalOverride::timerange).isPresent() && !searchType.timerange().isPresent()) {
                    return Optional.empty();
                }
                Set<String> usedStreamIds = searchType.effectiveStreams().isEmpty() ? query.usedStreamIds() : searchType.effectiveStreams();
                return Optional.of(this.indexLookup.indexNamesForStreamsInTimeRange(usedStreamIds, query.effectiveTimeRange((SearchType)searchType)));
            }).orElse(affectedIndices);
            return ((Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(((SearchSourceBuilder)searchTypeQueries.get(searchTypeId)).toString()).addType("message")).addIndex(affectedIndicesForSearchType.isEmpty() ? Collections.singleton("") : affectedIndicesForSearchType)).allowNoIndices(false)).ignoreUnavailable(false)).build();
        }).collect(Collectors.toList());
        MultiSearch.Builder multiSearchBuilder = new MultiSearch.Builder(searches);
        MultiSearchResult result = (MultiSearchResult)JestUtils.execute(this.jestClient, multiSearchBuilder.build(), () -> "Unable to perform search query: ");
        for (SearchType searchType : query.searchTypes()) {
            ElasticsearchException e;
            String searchTypeId2 = searchType.id();
            Provider<ESSearchTypeHandler<? extends SearchType>> handlerProvider = this.elasticsearchSearchTypeHandlers.get(searchType.type());
            if (handlerProvider == null) {
                LOG.error("Unknown search type '{}', cannot convert query result.", (Object)searchType.type());
                continue;
            }
            ESSearchTypeHandler handler = (ESSearchTypeHandler)handlerProvider.get();
            int searchTypeIndex = searchTypeIds.indexOf(searchTypeId2);
            MultiSearchResult.MultiSearchResponse multiSearchResponse = (MultiSearchResult.MultiSearchResponse)result.getResponses().get(searchTypeIndex);
            if (multiSearchResponse.isError) {
                e = JestUtils.specificException(() -> "Search type returned error: ", multiSearchResponse.error);
                queryContext.addError(SearchTypeErrorParser.parse(query, searchTypeId2, e));
                continue;
            }
            if (JestUtils.checkForFailedShards((JestResult)multiSearchResponse.searchResult).isPresent()) {
                e = JestUtils.checkForFailedShards((JestResult)multiSearchResponse.searchResult).get();
                queryContext.addError(SearchTypeErrorParser.parse(query, searchTypeId2, e));
                continue;
            }
            SearchType.Result searchTypeResult = handler.extractResult(job, query, searchType, multiSearchResponse.searchResult, queryContext);
            if (searchTypeResult == null) continue;
            resultsMap.put(searchTypeId2, searchTypeResult);
        }
        LOG.debug("Query {} ran for job {}", (Object)query.id(), (Object)job.getId());
        return QueryResult.builder().query(query).searchTypes(resultsMap).errors(new HashSet<SearchError>(queryContext.errors())).build();
    }

    private Set<String> queryStringsFromFilter(Filter entry) {
        if (entry != null) {
            Traverser filterTraverser = Traverser.forTree(filter -> (Set)MoreObjects.firstNonNull(filter.filters(), Collections.emptySet()));
            return StreamSupport.stream(filterTraverser.breadthFirst((Object)entry).spliterator(), false).filter(filter -> filter instanceof QueryStringFilter).map(queryStringFilter -> ((QueryStringFilter)queryStringFilter).query()).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public QueryMetadata parse(ImmutableSet<Parameter> declaredParameters, Query query) {
        Preconditions.checkArgument((boolean)(query.query() instanceof ElasticsearchQueryString));
        String mainQueryString = ((ElasticsearchQueryString)query.query()).queryString();
        Stream<String> queryStringStreams = Stream.concat(Stream.of(mainQueryString), query.searchTypes().stream().flatMap(this::queryStringsFromSearchType));
        QueryMetadata metadataForParameters = queryStringStreams.map(this.queryStringParser::parse).reduce(QueryMetadata.builder().build(), (meta1, meta2) -> QueryMetadata.builder().usedParameterNames((Set<String>)Sets.union(meta1.usedParameterNames(), meta2.usedParameterNames())).build());
        return metadataForParameters;
    }

    private Stream<String> queryStringsFromSearchType(SearchType searchType) {
        return Stream.concat(searchType.query().filter(query -> query instanceof ElasticsearchQueryString).map(query -> ((ElasticsearchQueryString)query).queryString()).map(Stream::of).orElse(Stream.empty()), this.queryStringsFromFilter(searchType.filter()).stream());
    }
}

