/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch.searchtypes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.inject.name.Named;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.ESQueryDecorators;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.ESSearchTypeHandler;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.pivot.LegacyDecoratorProcessor;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.joda.time.DateTime;

public class ESMessageList
implements ESSearchTypeHandler<MessageList> {
    private final ESQueryDecorators esQueryDecorators;
    private final LegacyDecoratorProcessor decoratorProcessor;
    private final boolean allowHighlighting;

    @Inject
    public ESMessageList(ESQueryDecorators esQueryDecorators, LegacyDecoratorProcessor decoratorProcessor, @Named(value="allow_highlighting") boolean allowHighlighting) {
        this.esQueryDecorators = esQueryDecorators;
        this.decoratorProcessor = decoratorProcessor;
        this.allowHighlighting = allowHighlighting;
    }

    @VisibleForTesting
    public ESMessageList(ESQueryDecorators esQueryDecorators) {
        this(esQueryDecorators, new LegacyDecoratorProcessor.Fake(), false);
    }

    @Override
    public void doGenerateQueryPart(SearchJob job, Query query, MessageList messageList, ESGeneratedQueryContext queryContext) {
        SearchSourceBuilder searchSourceBuilder = queryContext.searchSourceBuilder(messageList).size(messageList.limit()).from(messageList.offset());
        this.applyHighlightingIfActivated(searchSourceBuilder, job, query);
        Set<String> effectiveStreamIds = messageList.effectiveStreams().isEmpty() ? query.usedStreamIds() : messageList.effectiveStreams();
        List sorts = (List)MoreObjects.firstNonNull(messageList.sort(), Collections.singletonList(Sort.create("timestamp", SortOrder.DESC)));
        sorts.forEach(sort -> {
            FieldSortBuilder fieldSort = (FieldSortBuilder)SortBuilders.fieldSort((String)sort.field()).order(sort.order());
            Optional<String> fieldType = queryContext.fieldType(effectiveStreamIds, sort.field());
            searchSourceBuilder.sort((SortBuilder)fieldType.map(arg_0 -> ((FieldSortBuilder)fieldSort).unmappedType(arg_0)).orElse(fieldSort));
        });
    }

    private void applyHighlightingIfActivated(SearchSourceBuilder searchSourceBuilder, SearchJob job, Query query) {
        if (!this.allowHighlighting) {
            return;
        }
        QueryStringQueryBuilder highlightQuery = this.decoratedHighlightQuery(job, query);
        searchSourceBuilder.highlighter((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().requireFieldMatch(Boolean.valueOf(false))).highlightQuery((QueryBuilder)highlightQuery)).field("*").fragmentSize(Integer.valueOf(0))).numOfFragments(Integer.valueOf(0)));
    }

    private QueryStringQueryBuilder decoratedHighlightQuery(SearchJob job, Query query) {
        String raw = ((ElasticsearchQueryString)query.query()).queryString();
        String decorated = this.esQueryDecorators.decorate(raw, job, query, Collections.emptySet());
        return QueryBuilders.queryStringQuery((String)decorated);
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, MessageList searchType, SearchResult result, MetricAggregation aggregations, ESGeneratedQueryContext queryContext) {
        List<ResultMessageSummary> messages = result.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource(hit.id, hit.index, (Map)hit.source, hit.highlight)).map(resultMessage -> ResultMessageSummary.create(resultMessage.highlightRanges, resultMessage.getMessage().getFields(), resultMessage.getIndex())).collect(Collectors.toList());
        String undecoratedQueryString = ((ElasticsearchQueryString)query.query()).queryString();
        String queryString = this.esQueryDecorators.decorate(undecoratedQueryString, job, query, Collections.emptySet());
        DateTime from = query.effectiveTimeRange(searchType).getFrom();
        DateTime to = query.effectiveTimeRange(searchType).getTo();
        SearchResponse searchResponse = SearchResponse.create(undecoratedQueryString, queryString, Collections.emptySet(), messages, Collections.emptySet(), 0L, result.getTotal(), from, to);
        SearchResponse decoratedSearchResponse = this.decoratorProcessor.decorateSearchResponse(searchResponse, searchType.decorators());
        MessageList.Result.Builder resultBuilder = MessageList.Result.result(searchType.id()).messages(decoratedSearchResponse.messages()).effectiveTimerange(AbsoluteRange.create(from, to)).totalResults(decoratedSearchResponse.totalResults());
        return searchType.name().map(resultBuilder::name).orElse(resultBuilder).build();
    }
}

