/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch.searchtypes.pivot.buckets;

import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.DateRangeAggregation;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.range.date.DateRangeAggregationBuilder;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.elasticsearch.ESGeneratedQueryContext;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.pivot.ESPivot;
import org.graylog.plugins.views.search.elasticsearch.searchtypes.pivot.ESPivotBucketSpecHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.DateRangeBucket;
import org.joda.time.base.AbstractDateTime;

public class ESDateRangeHandler
extends ESPivotBucketSpecHandler<DateRangeBucket, DateRangeAggregation> {
    @Override
    @Nonnull
    public Optional<AggregationBuilder> doCreateAggregation(String name, Pivot pivot, DateRangeBucket dateRangeBucket, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext, Query query) {
        DateRangeAggregationBuilder builder = (DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)name).field(dateRangeBucket.field());
        dateRangeBucket.ranges().forEach(r -> {
            String from = r.from().map(AbstractDateTime::toString).orElse(null);
            String to = r.to().map(AbstractDateTime::toString).orElse(null);
            if (from != null && to != null) {
                builder.addRange(from, to);
            } else if (to != null) {
                builder.addUnboundedTo(to);
            } else if (from != null) {
                builder.addUnboundedFrom(from);
            }
        });
        builder.format("date_time");
        builder.keyed(false);
        this.record(esGeneratedQueryContext, pivot, dateRangeBucket, name, DateRangeAggregation.class);
        return Optional.of(builder);
    }

    @Override
    public Stream<ESPivotBucketSpecHandler.Bucket> doHandleResult(Pivot pivot, DateRangeBucket dateRangeBucket, SearchResult searchResult, DateRangeAggregation rangeAggregation, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        if (dateRangeBucket.bucketKey().equals((Object)DateRangeBucket.BucketKey.TO)) {
            return rangeAggregation.getBuckets().stream().map(range -> ESPivotBucketSpecHandler.Bucket.create(range.getToAsString(), (MetricAggregation)range));
        }
        return rangeAggregation.getBuckets().stream().map(range -> ESPivotBucketSpecHandler.Bucket.create(range.getFromAsString(), (MetricAggregation)range));
    }
}

