/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export.es;

import com.google.inject.name.Named;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.export.ExportBackend;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.SimpleMessage;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog.plugins.views.search.export.es.RequestStrategy;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchExportBackend
implements ExportBackend {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchExportBackend.class);
    private final IndexLookup indexLookup;
    private final RequestStrategy requestStrategy;
    private final boolean allowLeadingWildcard;

    @Inject
    public ElasticsearchExportBackend(IndexLookup indexLookup, RequestStrategy requestStrategy, @Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcard) {
        this.indexLookup = indexLookup;
        this.requestStrategy = requestStrategy;
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    @Override
    public void run(ExportMessagesCommand request, Consumer<SimpleMessageChunk> chunkCollector) {
        boolean isFirstChunk = true;
        int totalCount = 0;
        List<SearchResult.Hit<Map, Void>> hits;
        while (!(hits = this.search(request)).isEmpty()) {
            boolean success = this.publishChunk(chunkCollector, hits, request.fieldsInOrder(), isFirstChunk);
            if (!success) {
                return;
            }
            if (request.limit().isPresent() && (totalCount += hits.size()) >= request.limit().getAsInt()) {
                LOG.info("Limit of {} reached. Stopping message retrieval.", (Object)request.limit().getAsInt());
                return;
            }
            isFirstChunk = false;
        }
        return;
    }

    private List<SearchResult.Hit<Map, Void>> search(ExportMessagesCommand request) {
        Search.Builder search = this.prepareSearchRequest(request);
        return this.requestStrategy.nextChunk(search, request);
    }

    private Search.Builder prepareSearchRequest(ExportMessagesCommand request) {
        SearchSourceBuilder ssb = this.searchSourceBuilderFrom(request);
        Set<String> indices = this.indicesFor(request);
        return (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(ssb.toString()).addType("message")).allowNoIndices(false)).ignoreUnavailable(false)).addIndex(indices);
    }

    private SearchSourceBuilder searchSourceBuilderFrom(ExportMessagesCommand request) {
        QueryBuilder query = this.queryFrom(request);
        SearchSourceBuilder ssb = new SearchSourceBuilder().query(query).size(request.chunkSize());
        return this.requestStrategy.configure(ssb);
    }

    private QueryBuilder queryFrom(ExportMessagesCommand request) {
        return QueryBuilders.boolQuery().filter(this.queryStringFilter(request)).filter(this.timestampFilter(request)).filter((QueryBuilder)this.streamsFilter(request));
    }

    private QueryBuilder queryStringFilter(ExportMessagesCommand request) {
        ElasticsearchQueryString backendQuery = request.queryString();
        return backendQuery.isEmpty() ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery((String)backendQuery.queryString()).allowLeadingWildcard(Boolean.valueOf(this.allowLeadingWildcard));
    }

    private QueryBuilder timestampFilter(ExportMessagesCommand request) {
        return Objects.requireNonNull(IndexHelper.getTimestampRangeFilter(request.timeRange()));
    }

    private TermsQueryBuilder streamsFilter(ExportMessagesCommand request) {
        return QueryBuilders.termsQuery((String)"streams", request.streams());
    }

    private Set<String> indicesFor(ExportMessagesCommand request) {
        return this.indexLookup.indexNamesForStreamsInTimeRange(request.streams(), request.timeRange());
    }

    private boolean publishChunk(Consumer<SimpleMessageChunk> chunkCollector, List<SearchResult.Hit<Map, Void>> hits, LinkedHashSet<String> desiredFieldsInOrder, boolean isFirstChunk) {
        SimpleMessageChunk hitsWithOnlyRelevantFields = this.buildHitsWithRelevantFields(hits, desiredFieldsInOrder);
        if (isFirstChunk) {
            hitsWithOnlyRelevantFields = hitsWithOnlyRelevantFields.toBuilder().isFirstChunk(true).build();
        }
        try {
            chunkCollector.accept(hitsWithOnlyRelevantFields);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Chunk publishing threw exception. Stopping search after queries", (Throwable)e);
            return false;
        }
    }

    private SimpleMessageChunk buildHitsWithRelevantFields(List<SearchResult.Hit<Map, Void>> hits, LinkedHashSet<String> desiredFieldsInOrder) {
        LinkedHashSet set = hits.stream().map(h -> this.buildHitWithAllFields((Map)h.source, h.index)).collect(Collectors.toCollection(LinkedHashSet::new));
        return SimpleMessageChunk.from(desiredFieldsInOrder, set);
    }

    private SimpleMessage buildHitWithAllFields(Map source, String index) {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        for (Object key : source.keySet()) {
            String name = (String)key;
            Object value = this.valueFrom(source, name);
            fields.put(name, value);
        }
        fields.put("_id", UUID.randomUUID().toString());
        return SimpleMessage.from(index, fields);
    }

    private Object valueFrom(Map source, String name) {
        if (name.equals("timestamp")) {
            return this.fixTimestampFormat(source.get("timestamp"));
        }
        return source.get(name);
    }

    private Object fixTimestampFormat(Object rawTimestamp) {
        try {
            return Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime(String.valueOf(rawTimestamp)).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Could not parse timestamp {}", rawTimestamp, (Object)e);
            return rawTimestamp;
        }
    }
}

