/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export.es;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.searchbox.client.JestResult;
import io.searchbox.core.ClearScroll;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.SearchScroll;
import io.searchbox.core.search.sort.Sort;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.es.JestWrapper;
import org.graylog.plugins.views.search.export.es.RequestStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scroll
implements RequestStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(Scroll.class);
    private static final String SCROLL_TIME = "1m";
    private final ObjectMapper objectMapper;
    private final JestWrapper jestWrapper;
    private String currentScrollId;

    @Inject
    public Scroll(ObjectMapper objectMapper, JestWrapper jestWrapper) {
        this.objectMapper = objectMapper;
        this.jestWrapper = jestWrapper;
    }

    @Override
    public List<SearchResult.Hit<Map, Void>> nextChunk(Search.Builder search, ExportMessagesCommand command) {
        List<SearchResult.Hit<Map, Void>> hits = this.retrieveHits(search);
        if (hits.isEmpty()) {
            this.cancelScroll();
        }
        return hits;
    }

    private List<SearchResult.Hit<Map, Void>> retrieveHits(Search.Builder search) {
        if (this.isFirstRequest()) {
            SearchResult result = this.search(search);
            this.currentScrollId = this.scrollIdFrom((JestResult)result);
            return result.getHits(Map.class, false);
        }
        JestResult result = this.continueScroll(this.currentScrollId);
        this.currentScrollId = this.scrollIdFrom(result);
        return this.hitsFrom(result);
    }

    private List<SearchResult.Hit<Map, Void>> hitsFrom(JestResult result) {
        return StreamSupport.stream(result.getJsonObject().path("hits").path("hits").spliterator(), false).map(this::hitFromSource).collect(Collectors.toList());
    }

    private boolean isFirstRequest() {
        return this.currentScrollId == null;
    }

    private void cancelScroll() {
        ClearScroll.Builder clearScrollBuilder = new ClearScroll.Builder().addScrollId(this.currentScrollId);
        Object result = this.jestWrapper.execute(clearScrollBuilder.build(), () -> "Failed to cancel scroll " + this.currentScrollId);
        if (!result.isSucceeded()) {
            LOG.error("Failed to cancel scroll with id " + this.currentScrollId);
        }
    }

    private SearchResult search(Search.Builder search) {
        Search.Builder modified = ((Search.Builder)search.setParameter("scroll", (Object)SCROLL_TIME)).addSort(this.unsorted());
        return (SearchResult)this.jestWrapper.execute(modified.build(), () -> "Failed to execute initial Scroll request");
    }

    private Sort unsorted() {
        return new Sort("_doc", Sort.Sorting.ASC);
    }

    private JestResult continueScroll(String scrollId) {
        SearchScroll scroll = new SearchScroll.Builder(scrollId, SCROLL_TIME).build();
        return this.jestWrapper.execute(scroll, () -> "Failed to execute Scroll request with scroll id " + this.currentScrollId);
    }

    private String scrollIdFrom(JestResult result) {
        return result.getJsonObject().path("_scroll_id").asText();
    }

    private SearchResult.Hit<Map, Void> hitFromSource(JsonNode hit) {
        String index = hit.path("_index").asText();
        return new SearchResult.Hit(new SearchResult(this.objectMapper), Map.class, hit.get("_source"), Void.class, null, Collections.emptyMap(), (List)Lists.newArrayList(), index, null, null, null);
    }
}

