/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchtypes.events.AutoValue_EventList;
import org.graylog.plugins.views.search.searchtypes.events.AutoValue_EventList_Result;
import org.graylog.plugins.views.search.searchtypes.events.EventSummary;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.EventListEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;

@JsonTypeName(value="events")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventList
implements SearchType {
    public static final String NAME = "events";

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @Nullable
    public abstract Filter filter();

    @JsonCreator
    public static Builder builder() {
        return new AutoValue_EventList.Builder().type(NAME).streams(Collections.emptySet());
    }

    public abstract Builder toBuilder();

    @Override
    public SearchType applyExecutionContext(ObjectMapper objectMapper, JsonNode state) {
        return this;
    }

    @Override
    public Set<String> effectiveStreams() {
        return ImmutableSet.of((Object)"000000000000000000000002", (Object)"000000000000000000000003");
    }

    @Override
    public SearchTypeEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return ((EventListEntity.Builder)EventListEntity.builder().streams((Set)this.mappedStreams(entityDescriptorIds))).filter(this.filter()).id(this.id()).name(this.name().orElse(null)).query(this.query().orElse(null)).type(this.type()).timerange(this.timerange().orElse(null)).build();
    }

    @AutoValue
    public static abstract class Result
    implements SearchType.Result {
        @Override
        @JsonProperty
        public abstract String id();

        @Override
        @JsonProperty
        public String type() {
            return EventList.NAME;
        }

        @JsonProperty
        public abstract List<EventSummary> events();

        public static Builder builder() {
            return new AutoValue_EventList_Result.Builder();
        }

        public static Builder result(String searchTypeId) {
            return Result.builder().id(searchTypeId);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder id(String var1);

            public abstract Builder name(String var1);

            public abstract Builder events(List<EventSummary> var1);

            public abstract Result build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder createDefault() {
            return EventList.builder().streams(Collections.emptySet());
        }

        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(String var1);

        @JsonProperty
        public abstract Builder name(@Nullable String var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty
        public abstract Builder query(@Nullable BackendQuery var1);

        @JsonProperty
        public abstract Builder timerange(@Nullable DerivedTimeRange var1);

        @JsonProperty
        public abstract Builder streams(Set<String> var1);

        public abstract EventList build();
    }
}

