/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import one.util.streamex.StreamEx;
import org.bson.types.ObjectId;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerStatus;
import org.graylog.scheduler.JobTriggerUpdate;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;

public class DBJobTriggerService {
    static final String COLLECTION_NAME = "scheduler_triggers";
    private static final String FIELD_ID = "_id";
    static final String FIELD_JOB_DEFINITION_ID = "job_definition_id";
    private static final String FIELD_LOCK_OWNER = "lock.owner";
    private static final String FIELD_LAST_LOCK_TIME = "lock.last_lock_time";
    private static final String FIELD_NEXT_TIME = "next_time";
    private static final String FIELD_START_TIME = "start_time";
    private static final String FIELD_END_TIME = "end_time";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_SCHEDULE = "schedule";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_UPDATED_AT = "updated_at";
    private static final String FIELD_TRIGGERED_AT = "triggered_at";
    private final String nodeId;
    private final JacksonDBCollection<JobTriggerDto, ObjectId> db;
    private final JobSchedulerClock clock;

    @Inject
    public DBJobTriggerService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, NodeId nodeId, JobSchedulerClock clock) {
        this.nodeId = nodeId.toString();
        this.clock = clock;
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), JobTriggerDto.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_JOB_DEFINITION_ID, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_LOCK_OWNER, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_STATUS, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_START_TIME, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_END_TIME, (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject(FIELD_NEXT_TIME, (Object)1));
    }

    public List<JobTriggerDto> all() {
        return ImmutableList.copyOf((Iterator)this.db.find().sort((DBObject)DBSort.desc((String)FIELD_ID)).iterator());
    }

    public Optional<JobTriggerDto> get(String id) {
        return Optional.ofNullable((JobTriggerDto)this.db.findOneById((Object)new ObjectId(id)));
    }

    public List<JobTriggerDto> getForJob(String jobDefinitionId) {
        if (Strings.isNullOrEmpty((String)jobDefinitionId)) {
            throw new IllegalArgumentException("jobDefinitionId cannot be null or empty");
        }
        DBQuery.Query query = DBQuery.is((String)FIELD_JOB_DEFINITION_ID, (Object)jobDefinitionId);
        try (DBCursor cursor = this.db.find(query);){
            ImmutableList triggers = ImmutableList.copyOf((Iterator)cursor.iterator());
            if (triggers.size() > 1) {
                throw new IllegalStateException("More than one trigger for job definition <" + jobDefinitionId + ">");
            }
            ImmutableList immutableList = triggers;
            return immutableList;
        }
    }

    public Map<String, List<JobTriggerDto>> getForJobs(Collection<String> jobDefinitionIds) {
        if (jobDefinitionIds == null) {
            throw new IllegalArgumentException("jobDefinitionIds cannot be null");
        }
        Set queryValues = jobDefinitionIds.stream().filter(Objects::nonNull).filter(id -> !Strings.isNullOrEmpty((String)id)).collect(Collectors.toSet());
        DBQuery.Query query = DBQuery.in((String)FIELD_JOB_DEFINITION_ID, queryValues);
        Map groupedTriggers = StreamEx.of((Collection)this.db.find(query).toArray()).groupingBy(JobTriggerDto::jobDefinitionId);
        for (Map.Entry entry : groupedTriggers.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            throw new IllegalStateException("More than one trigger for job definition <" + (String)entry.getKey() + ">");
        }
        return groupedTriggers;
    }

    public JobTriggerDto create(JobTriggerDto trigger) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        if (trigger.id() != null) {
            throw new IllegalArgumentException("New trigger must not have an ID");
        }
        return (JobTriggerDto)this.db.insert((Object)trigger).getSavedObject();
    }

    public boolean update(JobTriggerDto trigger) {
        Optional<Map<String, Object>> scheduleUpdate;
        Objects.requireNonNull(trigger, "trigger cannot be null");
        if (Strings.isNullOrEmpty((String)trigger.id())) {
            throw new IllegalArgumentException("Trigger must have an ID");
        }
        DBUpdate.Builder update = DBUpdate.set((String)FIELD_START_TIME, (Object)trigger.startTime()).set(FIELD_NEXT_TIME, (Object)trigger.nextTime()).set(FIELD_DATA, trigger.data()).set(FIELD_UPDATED_AT, (Object)this.clock.nowUTC());
        if (trigger.endTime().isPresent()) {
            update.set(FIELD_END_TIME, trigger.endTime());
        }
        if ((scheduleUpdate = trigger.schedule().toDBUpdate("schedule.")).isPresent()) {
            JobTriggerDto oldTrigger = this.get(trigger.id()).orElseThrow(() -> new IllegalStateException("Couldn't find trigger with ID " + trigger.id()));
            Set oldKeys = ((Map)oldTrigger.schedule().toDBUpdate("schedule.").orElse(new HashMap())).keySet();
            Set<String> newKeys = scheduleUpdate.get().keySet();
            Sets.SetView toUnset = Sets.difference(oldKeys, newKeys);
            toUnset.forEach(arg_0 -> ((DBUpdate.Builder)update).unset(arg_0));
            scheduleUpdate.get().forEach((arg_0, arg_1) -> ((DBUpdate.Builder)update).set(arg_0, arg_1));
        }
        return this.db.update(DBQuery.is((String)FIELD_ID, (Object)this.getId(trigger)), update).getN() > 0;
    }

    public boolean delete(String triggerId) {
        if (Strings.isNullOrEmpty((String)triggerId)) {
            throw new IllegalArgumentException("triggerId cannot be null or empty");
        }
        return this.db.remove(DBQuery.is((String)FIELD_ID, (Object)triggerId)).getN() > 0;
    }

    public int deleteCompletedOnceSchedulesOlderThan(long timeValue, TimeUnit unit) {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, null), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.COMPLETE)), DBQuery.is((String)"schedule.type", (Object)"once"), DBQuery.lessThan((String)FIELD_UPDATED_AT, (Object)this.clock.nowUTC().minus(unit.toMillis(timeValue)))});
        return this.db.remove(query).getN();
    }

    public Optional<JobTriggerDto> nextRunnableTrigger() {
        DateTime now = this.clock.nowUTC();
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, null), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNABLE)), DBQuery.lessThanEquals((String)FIELD_START_TIME, (Object)now), DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notExists((String)FIELD_END_TIME), DBQuery.is((String)FIELD_END_TIME, null), DBQuery.greaterThan((String)FIELD_END_TIME, Optional.of(now))}), DBQuery.lessThanEquals((String)FIELD_NEXT_TIME, (Object)now)});
        DBSort.SortBuilder sort = DBSort.asc((String)FIELD_NEXT_TIME);
        DBUpdate.Builder lockUpdate = DBUpdate.set((String)FIELD_LOCK_OWNER, (Object)this.nodeId).set(FIELD_STATUS, (Object)JobTriggerStatus.RUNNING).set(FIELD_TRIGGERED_AT, Optional.of(now)).set(FIELD_LAST_LOCK_TIME, (Object)now);
        JobTriggerDto trigger = (JobTriggerDto)this.db.findAndModify(query, null, (DBObject)sort, false, lockUpdate, true, false);
        return Optional.ofNullable(trigger);
    }

    public boolean releaseTrigger(JobTriggerDto trigger, JobTriggerUpdate triggerUpdate) {
        int changedDocs;
        Objects.requireNonNull(trigger, "trigger cannot be null");
        Objects.requireNonNull(triggerUpdate, "triggerUpdate cannot be null");
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, (Object)this.nodeId), DBQuery.is((String)FIELD_ID, (Object)this.getId(trigger)), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING))});
        DBUpdate.Builder update = DBUpdate.set((String)FIELD_LOCK_OWNER, null);
        if (triggerUpdate.nextTime().isPresent()) {
            if (triggerUpdate.status().isPresent()) {
                update.set(FIELD_STATUS, (Object)triggerUpdate.status().get());
            } else {
                update.set(FIELD_STATUS, (Object)JobTriggerStatus.RUNNABLE);
            }
            update.set(FIELD_NEXT_TIME, (Object)triggerUpdate.nextTime().get());
        } else {
            update.set(FIELD_STATUS, (Object)JobTriggerStatus.COMPLETE);
        }
        if (triggerUpdate.data().isPresent()) {
            update.set(FIELD_DATA, triggerUpdate.data());
        }
        if ((changedDocs = this.db.update(query, update).getN()) > 1) {
            throw new IllegalStateException("Expected to release only one trigger (id=" + trigger.id() + ") but database query modified " + changedDocs);
        }
        return changedDocs == 1;
    }

    public int forceReleaseOwnedTriggers() {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, (Object)this.nodeId), DBQuery.is((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING))});
        DBUpdate.Builder update = DBUpdate.set((String)FIELD_LOCK_OWNER, null).set(FIELD_STATUS, (Object)JobTriggerStatus.RUNNABLE);
        return this.db.updateMulti(query, update).getN();
    }

    public boolean setTriggerError(JobTriggerDto trigger) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)FIELD_LOCK_OWNER, (Object)this.nodeId), DBQuery.is((String)FIELD_ID, (Object)this.getId(trigger))});
        DBUpdate.Builder update = DBUpdate.set((String)FIELD_LOCK_OWNER, null).set(FIELD_STATUS, (Object)JobTriggerStatus.ERROR);
        return this.db.update(query, update).getN() > 0;
    }

    private ObjectId getId(JobTriggerDto trigger) {
        return new ObjectId(Objects.requireNonNull(trigger.id(), "trigger ID cannot be null"));
    }
}

