/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog.plugins.views.search.timeranges.OffsetRange;
import org.graylog2.contentpacks.model.entities.AutoValue_MessageListEntity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.decorators.Decorator;
import org.graylog2.decorators.DecoratorImpl;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonTypeName(value="messages")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class MessageListEntity
implements SearchTypeEntity {
    public static final String NAME = "messages";

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @JsonProperty
    public abstract Optional<String> name();

    @Override
    @Nullable
    public abstract Filter filter();

    @JsonProperty
    public abstract int limit();

    @JsonProperty
    public abstract int offset();

    @Nullable
    public abstract List<Sort> sort();

    @JsonProperty
    public abstract List<Decorator> decorators();

    @JsonCreator
    public static Builder builder() {
        return ((Builder)new AutoValue_MessageListEntity.Builder().type(NAME).limit(150).offset(0).streams(Collections.emptySet())).decorators(Collections.emptyList());
    }

    public abstract Builder toBuilder();

    @Override
    public Builder toGenericBuilder() {
        return this.toBuilder();
    }

    @Override
    public SearchType toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        return MessageList.builder().limit(this.limit()).streams(this.mappedStreams(nativeEntities)).id(this.id()).offset(this.offset()).decorators(this.decorators()).timerange((DerivedTimeRange)this.timerange().orElse(null)).filter(this.filter()).name(this.name().orElse(null)).type(this.type()).query(this.query().orElse(null)).sort(this.sort()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements SearchTypeEntity.Builder {
        @JsonCreator
        public static Builder createDefault() {
            return MessageListEntity.builder().streams(Collections.emptySet());
        }

        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        @JsonProperty
        public abstract Builder name(@Nullable String var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
        @JsonSubTypes(value={@JsonSubTypes.Type(name="absolute", value=AbsoluteRange.class), @JsonSubTypes.Type(name="relative", value=RelativeRange.class), @JsonSubTypes.Type(name="keyword", value=KeywordRange.class), @JsonSubTypes.Type(name="offset", value=OffsetRange.class)})
        public Builder timerange(@Nullable TimeRange timerange) {
            return this.timerange(timerange == null ? null : DerivedTimeRange.of(timerange));
        }

        public abstract Builder timerange(@Nullable DerivedTimeRange var1);

        @JsonProperty
        public abstract Builder query(@Nullable BackendQuery var1);

        @Override
        @JsonProperty
        public abstract Builder streams(Set<String> var1);

        @JsonProperty
        public abstract Builder limit(int var1);

        @JsonProperty
        public abstract Builder offset(int var1);

        @JsonProperty
        public abstract Builder sort(@Nullable List<Sort> var1);

        @JsonProperty(value="decorators")
        public Builder _decorators(List<DecoratorImpl> decorators) {
            return this.decorators(new ArrayList<Decorator>(decorators));
        }

        public abstract Builder decorators(List<Decorator> var1);

        @Override
        public abstract MessageListEntity build();
    }
}

