/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards;

import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardImpl;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.events.DashboardDeletedEvent;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.DashboardWidgetCreator;
import org.graylog2.dashboards.widgets.events.WidgetUpdatedEvent;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardServiceImpl
extends PersistedServiceImpl
implements DashboardService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardServiceImpl.class);
    private final DashboardWidgetCreator dashboardWidgetCreator;
    private final ClusterEventBus clusterEventBus;
    private final EventBus serverEventBus;

    @Inject
    public DashboardServiceImpl(MongoConnection mongoConnection, DashboardWidgetCreator dashboardWidgetCreator, ClusterEventBus clusterEventBus, EventBus serverEventBus) {
        super(mongoConnection);
        this.dashboardWidgetCreator = dashboardWidgetCreator;
        this.clusterEventBus = clusterEventBus;
        this.serverEventBus = serverEventBus;
    }

    @Override
    public Dashboard create(String title, String description, String creatorUserId, DateTime createdAt) {
        HashMap dashboardData = Maps.newHashMap();
        dashboardData.put("title", title);
        dashboardData.put("description", description);
        dashboardData.put("creator_user_id", creatorUserId);
        dashboardData.put("created_at", createdAt);
        return new DashboardImpl(dashboardData);
    }

    private Dashboard create(ObjectId id, Map<String, Object> fields) {
        DashboardImpl dashboard = new DashboardImpl(id, fields);
        if (fields.containsKey("widgets") && fields.get("widgets") instanceof List) {
            for (BasicDBObject widgetFields : (List)fields.get("widgets")) {
                try {
                    DashboardWidget widget = this.dashboardWidgetCreator.fromPersisted(widgetFields);
                    dashboard.addPersistedWidget(widget);
                }
                catch (InvalidRangeParametersException e) {
                    LOG.error("Invalid range parameters of widget in dashboard: [" + dashboard.getId() + "]", (Throwable)e);
                }
            }
        }
        return dashboard;
    }

    @Override
    public Dashboard load(String id) throws NotFoundException {
        BasicDBObject o = (BasicDBObject)this.get(DashboardImpl.class, id);
        if (o == null) {
            throw new NotFoundException("Couldn't find dashboard with ID " + id);
        }
        return this.create((ObjectId)o.get("_id"), o.toMap());
    }

    @Override
    public List<Dashboard> all() {
        List<DBObject> results = this.query(DashboardImpl.class, (DBObject)new BasicDBObject());
        Stream<Dashboard> dashboardStream = results.stream().map(o -> new DashboardImpl((ObjectId)o.get("_id"), o.toMap()));
        return dashboardStream.collect(Collectors.toList());
    }

    @Override
    public Set<Dashboard> loadByIds(Collection<String> ids) {
        Set objectIds = ids.stream().map(ObjectId::new).collect(Collectors.toSet());
        DBObject query = BasicDBObjectBuilder.start().push("_id").append("$in", objectIds).get();
        List<DBObject> results = this.query(DashboardImpl.class, query);
        Stream<Dashboard> dashboardStream = results.stream().map(o -> new DashboardImpl((ObjectId)o.get("_id"), o.toMap()));
        return dashboardStream.collect(Collectors.toSet());
    }

    @Override
    public void removeWidget(Dashboard dashboard, DashboardWidget widget) {
        this.removeEmbedded(dashboard, "widgets", widget.getId());
        dashboard.removeWidget(widget);
        this.clusterEventBus.post(WidgetUpdatedEvent.create(widget));
    }

    @Override
    public long count() {
        return this.totalCount(DashboardImpl.class);
    }

    @Override
    public int destroy(Dashboard dashboard) {
        String dashboardId = dashboard.getId();
        Set widgetIds = dashboard.getWidgets().values().stream().map(DashboardWidget::getId).collect(Collectors.toSet());
        int destroyedDashboards = super.destroy(dashboard);
        for (String widgetId : widgetIds) {
            this.clusterEventBus.post(WidgetUpdatedEvent.create(widgetId));
        }
        this.serverEventBus.post((Object)DashboardDeletedEvent.create(dashboardId));
        return destroyedDashboards;
    }
}

