/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import io.searchbox.client.JestClient;
import io.searchbox.cluster.Health;
import io.searchbox.cluster.NodesInfo;
import io.searchbox.core.Cat;
import io.searchbox.core.CatResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettings;
import org.graylog2.indexer.cluster.health.ClusterAllocationDiskSettingsFactory;
import org.graylog2.indexer.cluster.health.NodeDiskUsageStats;
import org.graylog2.indexer.cluster.health.NodeFileDescriptorStats;
import org.graylog2.indexer.cluster.jest.GetAllocationDiskSettings;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Cluster {
    private static final Logger LOG = LoggerFactory.getLogger(Cluster.class);
    private final JestClient jestClient;
    private final IndexSetRegistry indexSetRegistry;
    private final ScheduledExecutorService scheduler;
    private final Duration requestTimeout;

    @Inject
    public Cluster(JestClient jestClient, IndexSetRegistry indexSetRegistry, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, @Named(value="elasticsearch_request_timeout") Duration requestTimeout) {
        this.scheduler = scheduler;
        this.jestClient = jestClient;
        this.indexSetRegistry = indexSetRegistry;
        this.requestTimeout = requestTimeout;
    }

    private Optional<JsonNode> clusterHealth(Collection<? extends String> indices) {
        Health request = ((Health.Builder)new Health.Builder().addIndex(indices)).timeout(Ints.saturatedCast((long)this.requestTimeout.toSeconds())).build();
        try {
            Object jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't read cluster health for indices " + indices);
            return Optional.of(jestResult.getJsonObject());
        }
        catch (ElasticsearchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("{} ({})", new Object[]{e.getMessage(), Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("n/a"), e});
            } else {
                LOG.error("{} ({})", (Object)e.getMessage(), (Object)Optional.ofNullable(e.getCause()).map(Throwable::getMessage).orElse("n/a"));
            }
            return Optional.empty();
        }
    }

    public Optional<JsonNode> health() {
        return this.clusterHealth(Arrays.asList(this.indexSetRegistry.getIndexWildcards()));
    }

    public Optional<JsonNode> deflectorHealth() {
        return this.clusterHealth(Arrays.asList(this.indexSetRegistry.getWriteIndexAliases()));
    }

    private JsonNode catNodes(String ... fields) {
        String fieldNames = String.join((CharSequence)",", fields);
        Cat request = ((Cat.NodesBuilder)((Cat.NodesBuilder)((Cat.NodesBuilder)new Cat.NodesBuilder().setParameter("h", (Object)fieldNames)).setParameter("full_id", (Object)true)).setParameter("format", (Object)"json")).build();
        CatResult response = (CatResult)JestUtils.execute(this.jestClient, request, () -> "Unable to read Elasticsearch node information");
        return response.getJsonObject().path("result");
    }

    public Set<NodeFileDescriptorStats> getFileDescriptorStats() {
        JsonNode nodes = this.catNodes("name", "host", "ip", "fileDescriptorMax");
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (JsonNode jsonElement : nodes) {
            if (!jsonElement.isObject()) continue;
            String name = jsonElement.path("name").asText();
            String host = jsonElement.path("host").asText(null);
            String ip = jsonElement.path("ip").asText();
            JsonNode fileDescriptorMax = jsonElement.path("fileDescriptorMax");
            Long maxFileDescriptors = fileDescriptorMax.isLong() ? Long.valueOf(fileDescriptorMax.asLong()) : null;
            setBuilder.add((Object)NodeFileDescriptorStats.create(name, ip, host, maxFileDescriptors));
        }
        return setBuilder.build();
    }

    public Set<NodeDiskUsageStats> getDiskUsageStats() {
        JsonNode nodes = this.catNodes("name", "host", "ip", "nodeRole", "diskUsed", "diskTotal", "diskUsedPercent");
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (JsonNode jsonElement : nodes) {
            if (!jsonElement.isObject() || !jsonElement.path("nodeRole").asText().contains("d")) continue;
            setBuilder.add((Object)NodeDiskUsageStats.create(jsonElement.path("name").asText(), jsonElement.path("ip").asText(), jsonElement.path("host").asText(null), jsonElement.path("diskUsed").asText(), jsonElement.path("diskTotal").asText(), jsonElement.path("diskUsedPercent").asDouble(-1.0)));
        }
        return setBuilder.build();
    }

    public ClusterAllocationDiskSettings getClusterAllocationDiskSettings() throws Exception {
        GetAllocationDiskSettings request = new GetAllocationDiskSettings.Builder().build();
        Object response = JestUtils.execute(this.jestClient, request, () -> "Unable to read Elasticsearch cluster settings");
        JsonNode json = response.getJsonObject();
        JsonNode floodStageSetting = this.findEffectiveSettingInSettingsGroups(json, "flood_stage", true);
        return ClusterAllocationDiskSettingsFactory.create(this.findEffectiveSettingInSettingsGroups(json, "threshold_enabled", false).asBoolean(), this.findEffectiveSettingInSettingsGroups(json, "low", false).asText(), this.findEffectiveSettingInSettingsGroups(json, "high", false).asText(), floodStageSetting != null ? floodStageSetting.asText() : "");
    }

    private JsonNode findEffectiveSettingInSettingsGroups(JsonNode jsonNode, String setting, boolean optional) throws Exception {
        List<String> settingsGroup = Arrays.asList("transient", "persistent", "defaults");
        for (String group : settingsGroup) {
            JsonNode foundSetting;
            JsonNode foundGroup = jsonNode.findPath(group);
            if (foundGroup instanceof MissingNode || (foundSetting = foundGroup.findPath(setting)) instanceof MissingNode) continue;
            return foundSetting;
        }
        if (optional) {
            return null;
        }
        throw new Exception(String.format(Locale.ENGLISH, "Could not find setting %s in Elasticsearch response", setting));
    }

    public Optional<String> nodeIdToName(String nodeId) {
        return Optional.ofNullable(this.getNodeInfo(nodeId).path("name").asText(null));
    }

    public Optional<String> nodeIdToHostName(String nodeId) {
        return Optional.ofNullable(this.getNodeInfo(nodeId).path("host").asText(null));
    }

    private JsonNode getNodeInfo(String nodeId) {
        if (nodeId == null || nodeId.isEmpty()) {
            return MissingNode.getInstance();
        }
        NodesInfo request = ((NodesInfo.Builder)new NodesInfo.Builder().addNode(nodeId)).build();
        Object result = JestUtils.execute(this.jestClient, request, () -> "Couldn't read information of Elasticsearch node " + nodeId);
        return result.getJsonObject().path("nodes").path(nodeId);
    }

    public boolean isConnected() {
        Health request = new Health.Builder().local().timeout(Ints.saturatedCast((long)this.requestTimeout.toSeconds())).build();
        try {
            Object result = JestUtils.execute(this.jestClient, request, () -> "Couldn't check connection status of Elasticsearch");
            int numberOfDataNodes = result.getJsonObject().path("number_of_data_nodes").asInt();
            return numberOfDataNodes > 0;
        }
        catch (ElasticsearchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public boolean isHealthy() {
        return this.health().map(health -> !"red".equals(health.path("status").asText()) && this.indexSetRegistry.isUp()).orElse(false);
    }

    public boolean isDeflectorHealthy() {
        return this.deflectorHealth().map(health -> !"red".equals(health.path("status").asText()) && this.indexSetRegistry.isUp()).orElse(false);
    }

    public void waitForConnectedAndDeflectorHealthy(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        LOG.debug("Waiting until the write-active index is healthy again, checking once per second.");
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
            try {
                if (this.isConnected() && this.isDeflectorHealthy()) {
                    LOG.debug("Write-active index is healthy again, unblocking waiting threads.");
                    latch.countDown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        boolean waitSuccess = latch.await(timeout, unit);
        scheduledFuture.cancel(true);
        if (!waitSuccess) {
            throw new TimeoutException("Write-active index didn't get healthy within timeout");
        }
    }

    public void waitForConnectedAndDeflectorHealthy() throws InterruptedException, TimeoutException {
        this.waitForConnectedAndDeflectorHealthy(this.requestTimeout.getQuantity(), this.requestTimeout.getUnit());
    }
}

