/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster.health;

import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog2.indexer.cluster.health.AutoValue_NodeDiskUsageStats;

@AutoValue
public abstract class NodeDiskUsageStats {
    public static final double DEFAULT_DISK_USED_PERCENT = -1.0;

    public abstract String name();

    public abstract String ip();

    @Nullable
    public abstract String host();

    public abstract ByteSizeValue diskTotal();

    public abstract ByteSizeValue diskUsed();

    public abstract ByteSizeValue diskAvailable();

    public abstract Double diskUsedPercent();

    public static NodeDiskUsageStats create(String name, String ip, @Nullable String host, String diskUsedString, String diskTotalString, Double diskUsedPercent) {
        ByteSizeValue diskTotal = ByteSizeValue.parseBytesSizeValue((String)diskTotalString, (String)"diskTotal");
        ByteSizeValue diskUsed = ByteSizeValue.parseBytesSizeValue((String)diskUsedString, (String)"diskUsed");
        ByteSizeValue diskAvailable = new ByteSizeValue(diskTotal.getBytes() - diskUsed.getBytes());
        return new AutoValue_NodeDiskUsageStats(name, ip, host, diskTotal, diskUsed, diskAvailable, diskUsedPercent);
    }
}

