/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.counts;

import io.searchbox.client.JestClient;
import io.searchbox.core.MultiSearch;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.jest.JestUtils;

@Singleton
public class Counts {
    private final JestClient jestClient;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public Counts(JestClient jestClient, IndexSetRegistry indexSetRegistry) {
        this.jestClient = jestClient;
        this.indexSetRegistry = indexSetRegistry;
    }

    public long total() {
        return this.totalCount(this.indexSetRegistry.getManagedIndices());
    }

    public long total(IndexSet indexSet) {
        return this.totalCount(indexSet.getManagedIndices());
    }

    private long totalCount(String[] indexNames) {
        if (indexNames.length == 0) {
            return 0L;
        }
        List<String> indices = Arrays.asList(indexNames);
        String query = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(0).toString();
        Search request = ((Search.Builder)new Search.Builder(query).addIndex(indices)).build();
        MultiSearch multiSearch = new MultiSearch.Builder(request).build();
        MultiSearchResult searchResult = (MultiSearchResult)JestUtils.execute(this.jestClient, multiSearch, () -> "Fetching message count failed for indices " + indices);
        List responses = searchResult.getResponses();
        long total = 0L;
        for (MultiSearchResult.MultiSearchResponse response : responses) {
            if (response.isError) {
                throw JestUtils.specificException(() -> "Fetching message count failed for indices " + indices, response.error);
            }
            total += response.searchResult.getTotal().longValue();
        }
        return total;
    }
}

