/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.google.common.base.Preconditions;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.indexset.DefaultIndexSetConfig;
import org.graylog2.indexer.indexset.DefaultIndexSetCreated;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161116172100_DefaultIndexSetMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161116172100_DefaultIndexSetMigration.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final Map<String, Provider<RotationStrategy>> rotationStrategies;
    private final Map<String, Provider<RetentionStrategy>> retentionStrategies;
    private final IndexSetService indexSetService;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20161116172100_DefaultIndexSetMigration(ElasticsearchConfiguration elasticsearchConfiguration, Map<String, Provider<RotationStrategy>> rotationStrategies, Map<String, Provider<RetentionStrategy>> retentionStrategies, IndexSetService indexSetService, ClusterConfigService clusterConfigService) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.rotationStrategies = Objects.requireNonNull(rotationStrategies);
        this.retentionStrategies = Objects.requireNonNull(retentionStrategies);
        this.indexSetService = indexSetService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2016-11-16T17:21:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(DefaultIndexSetCreated.class) != null) {
            return;
        }
        IndexManagementConfig indexManagementConfig = this.clusterConfigService.get(IndexManagementConfig.class);
        Preconditions.checkState((indexManagementConfig != null ? 1 : 0) != 0, (Object)"Couldn't find index management configuration");
        IndexSetConfig config = IndexSetConfig.builder().title("Default index set").description("The Graylog default index set").indexPrefix(this.elasticsearchConfiguration.getIndexPrefix()).shards(this.elasticsearchConfiguration.getShards()).replicas(this.elasticsearchConfiguration.getReplicas()).rotationStrategy(this.getRotationStrategyConfig(indexManagementConfig)).retentionStrategy(this.getRetentionStrategyConfig(indexManagementConfig)).creationDate(ZonedDateTime.now(ZoneOffset.UTC)).indexAnalyzer(this.elasticsearchConfiguration.getAnalyzer()).indexTemplateName(this.elasticsearchConfiguration.getTemplateName()).indexOptimizationMaxNumSegments(this.elasticsearchConfiguration.getIndexOptimizationMaxNumSegments()).indexOptimizationDisabled(this.elasticsearchConfiguration.isDisableIndexOptimization()).build();
        IndexSetConfig savedConfig = this.indexSetService.save(config);
        this.clusterConfigService.write(DefaultIndexSetConfig.create(savedConfig.id()));
        this.clusterConfigService.write(DefaultIndexSetCreated.create());
        LOG.debug("Successfully created default index set: {}", (Object)savedConfig);
    }

    private RotationStrategyConfig getRotationStrategyConfig(IndexManagementConfig indexManagementConfig) {
        String strategyName = indexManagementConfig.rotationStrategy();
        Provider<RotationStrategy> provider = this.rotationStrategies.get(strategyName);
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)("Couldn't retrieve rotation strategy provider for <" + strategyName + ">"));
        RotationStrategy rotationStrategy = (RotationStrategy)provider.get();
        Class<? extends RotationStrategyConfig> configClass = rotationStrategy.configurationClass();
        RotationStrategyConfig rotationStrategyConfig = this.clusterConfigService.get(configClass);
        Preconditions.checkState((rotationStrategyConfig != null ? 1 : 0) != 0, (Object)("Couldn't retrieve rotation strategy config for <" + strategyName + ">"));
        return rotationStrategyConfig;
    }

    private RetentionStrategyConfig getRetentionStrategyConfig(IndexManagementConfig indexManagementConfig) {
        String strategyName = indexManagementConfig.retentionStrategy();
        Provider<RetentionStrategy> provider = this.retentionStrategies.get(strategyName);
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)("Couldn't retrieve retention strategy provider for <" + strategyName + ">"));
        RetentionStrategy retentionStrategy = (RetentionStrategy)provider.get();
        Class<? extends RetentionStrategyConfig> configClass = retentionStrategy.configurationClass();
        RetentionStrategyConfig retentionStrategyConfig = this.clusterConfigService.get(configClass);
        Preconditions.checkState((retentionStrategyConfig != null ? 1 : 0) != 0, (Object)("Couldn't retrieve retention strategy config for <" + strategyName + ">"));
        return retentionStrategyConfig;
    }
}

