/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.outputs.MessageOutputConfigurationException;
import org.graylog2.plugin.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingOutput
implements MessageOutput {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingOutput.class);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final Configuration configuration;

    @Inject
    public LoggingOutput(@Assisted Configuration config) throws MessageOutputConfigurationException {
        LOG.info("Initializing");
        this.configuration = config;
        this.isRunning.set(true);
    }

    @Override
    public void stop() {
        this.isRunning.set(false);
        LOG.info("Stopping");
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    @Override
    public void write(Message message) throws Exception {
        LOG.info("{} {}", (Object)this.configuration.getString("prefix"), (Object)message);
    }

    @Override
    public void write(List<Message> messages) throws Exception {
        for (Message message : messages) {
            this.write(message);
        }
    }

    public static class Config
    extends MessageOutput.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest configurationRequest = new ConfigurationRequest();
            configurationRequest.addField(new TextField("prefix", "Prefix", "Writing message: ", "How to prefix the message before logging it", ConfigurationField.Optional.OPTIONAL));
            return configurationRequest;
        }
    }

    public static class Descriptor
    extends MessageOutput.Descriptor {
        public Descriptor() {
            super("STDOUT Output", false, "", "An output writing every message to STDOUT.");
        }
    }

    public static interface Factory
    extends MessageOutput.Factory<LoggingOutput> {
        @Override
        public LoggingOutput create(Stream var1, Configuration var2);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

