/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.rest.resources.search.SearchResource;
import org.graylog2.savedsearches.SavedSearch;
import org.graylog2.savedsearches.SavedSearchService;

@RequiresAuthentication
@Api(value="Legacy/Search/Saved", description="Saved searches")
@Path(value="/legacy/search/saved")
public class LegacySavedSearchesResource
extends SearchResource {
    private final SavedSearchService savedSearchService;

    @Inject
    public LegacySavedSearchesResource(Searches searches, SavedSearchService savedSearchService, ClusterConfigService clusterConfigService, DecoratorProcessor decoratorProcessor) {
        super(searches, clusterConfigService, decoratorProcessor);
        this.savedSearchService = savedSearchService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all saved searches")
    @Produces(value={"application/json"})
    public Map<String, Object> list() {
        ArrayList searches = Lists.newArrayList();
        for (SavedSearch search : this.savedSearchService.all()) {
            if (!this.isPermitted("savedsearches:read", search.getId())) continue;
            searches.add(search.asMap());
        }
        return ImmutableMap.of((Object)"total", (Object)searches.size(), (Object)"searches", (Object)searches);
    }

    @GET
    @Path(value="/{searchId}")
    @Timed
    @ApiOperation(value="Get a single saved search")
    @ApiResponses(value={@ApiResponse(code=404, message="Saved search not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public Map<String, Object> get(@ApiParam(name="searchId", required=true) @PathParam(value="searchId") String searchId) throws NotFoundException {
        this.checkPermission("savedsearches:read", searchId);
        return this.savedSearchService.load(searchId).asMap();
    }

    @DELETE
    @Path(value="/{searchId}")
    @Timed
    @ApiOperation(value="Delete a saved search")
    @ApiResponses(value={@ApiResponse(code=404, message="Saved search not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:saved_search:delete")
    public void delete(@ApiParam(name="searchId", required=true) @PathParam(value="searchId") String searchId) throws NotFoundException {
        this.checkPermission("savedsearches:edit", searchId);
        SavedSearch search = this.savedSearchService.load(searchId);
        this.savedSearchService.destroy(search);
    }
}

