/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.processing;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.rest.models.system.processing.ProcessingStatusSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.processing.DBProcessingStatusService;
import org.graylog2.system.processing.ProcessingStatusRecorder;

@Api(value="System/Processing/Status")
@Path(value="/system/processing/status")
@RequiresAuthentication
@Produces(value={"application/json"})
public class SystemProcessingStatusResource
extends RestResource {
    private final ProcessingStatusRecorder processingStatusRecorder;
    private final DBProcessingStatusService dbService;

    @Inject
    public SystemProcessingStatusResource(ProcessingStatusRecorder processingStatusRecorder, DBProcessingStatusService dbService) {
        this.processingStatusRecorder = processingStatusRecorder;
        this.dbService = dbService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get processing status summary from node")
    public ProcessingStatusSummary getStatus() {
        return ProcessingStatusSummary.of(this.processingStatusRecorder);
    }

    @GET
    @Path(value="/persisted")
    @Timed
    @ApiOperation(value="Get persisted processing status summary from node")
    public ProcessingStatusSummary getPersistedStatus() {
        return this.dbService.get().map(ProcessingStatusSummary::of).orElseThrow(() -> new NotFoundException("No processing status persisted yet"));
    }
}

