/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.graylog2.security.;

@AutoValue
public abstract class AuthenticationConfig {
    @JsonProperty(value="realm_order")
    public abstract List<String> realmOrder();

    @JsonProperty(value="disabled_realms")
    public abstract Set<String> disabledRealms();

    @JsonCreator
    public static AuthenticationConfig create(@JsonProperty(value="realm_order") List<String> order, @JsonProperty(value="disabled_realms") Set<String> disabledRealms) {
        return AuthenticationConfig.builder().realmOrder(order).disabledRealms(disabledRealms).build();
    }

    public static AuthenticationConfig defaultInstance() {
        return AuthenticationConfig.builder().realmOrder((List<String>)ImmutableList.of((Object)"mongodb-session", (Object)"access-token", (Object)"legacy-ldap", (Object)"mongodb-password", (Object)"root-user")).disabledRealms(Collections.emptySet()).build();
    }

    public AuthenticationConfig withRealms(Set<String> availableRealms) {
        ArrayList<String> newOrder = new ArrayList<String>();
        this.realmOrder().stream().filter(availableRealms::contains).forEach(newOrder::add);
        availableRealms.stream().filter(realm -> !newOrder.contains(realm)).sorted(String.CASE_INSENSITIVE_ORDER).forEach(newOrder::add);
        return this.toBuilder().realmOrder(newOrder).build();
    }

    public abstract Builder toBuilder();

    private static Builder builder() {
        return new .AutoValue_AuthenticationConfig.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder realmOrder(List<String> var1);

        public abstract Builder disabledRealms(Set<String> var1);

        public abstract AuthenticationConfig build();
    }
}

