/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.processing;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;

public class ProcessingStatusConfig {
    private static final String PREFIX = "processing_status_";
    static final String PERSIST_INTERVAL = "processing_status_persist_interval";
    static final String UPDATE_THRESHOLD = "processing_status_update_threshold";
    static final String JOURNAL_WRITE_RATE_THRESHOLD = "processing_status_journal_write_rate_threshold";
    @Parameter(value="processing_status_persist_interval", validators={PositiveDurationValidator.class, Minimum1SecondValidator.class})
    private Duration processingStatusPersistInterval = Duration.seconds((long)1L);
    @Parameter(value="processing_status_update_threshold", validators={PositiveDurationValidator.class, Minimum1SecondValidator.class})
    private Duration updateThreshold = Duration.minutes((long)1L);
    @Parameter(value="processing_status_journal_write_rate_threshold", validators={PositiveIntegerValidator.class})
    private int journalWriteRateThreshold = 1;

    public Duration getProcessingStatusPersistInterval() {
        return this.processingStatusPersistInterval;
    }

    public Duration getUpdateThreshold() {
        return this.updateThreshold;
    }

    public int getJournalWriteRateThreshold() {
        return this.journalWriteRateThreshold;
    }

    public static class Minimum1SecondValidator
    implements Validator<Duration> {
        public void validate(String name, Duration value) throws ValidationException {
            if (value != null && value.compareTo(Duration.seconds((long)1L)) < 0) {
                throw new ValidationException("Parameter " + name + " should be at least 1 second (found " + value + ")");
            }
        }
    }
}

