/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import io.searchbox.client.JestClient;
import io.searchbox.cluster.Health;
import io.searchbox.cluster.PendingClusterTasks;
import io.searchbox.cluster.Stats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.graylog2.system.stats.elasticsearch.ClusterHealth;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.graylog2.system.stats.elasticsearch.IndicesStats;
import org.graylog2.system.stats.elasticsearch.NodesStats;

@Singleton
public class ElasticsearchProbe {
    private final JestClient jestClient;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public ElasticsearchProbe(JestClient jestClient, IndexSetRegistry indexSetRegistry) {
        this.jestClient = jestClient;
        this.indexSetRegistry = indexSetRegistry;
    }

    public ElasticsearchStats elasticsearchStats() {
        ArrayNode versions;
        JsonNode versionNode;
        Object clusterStatsResponse = JestUtils.execute(this.jestClient, new Stats.Builder().build(), () -> "Couldn't read Elasticsearch cluster stats");
        JsonNode clusterStatsResponseJson = clusterStatsResponse.getJsonObject();
        String clusterName = clusterStatsResponseJson.path("cluster_name").asText();
        String clusterVersion = null;
        if (clusterStatsResponseJson.path("nodes").path("versions").isArray() && (versionNode = (versions = (ArrayNode)clusterStatsResponseJson.path("nodes").path("versions")).path(0)).getNodeType() != JsonNodeType.MISSING) {
            clusterVersion = versionNode.asText();
        }
        JsonNode countStats = clusterStatsResponseJson.path("nodes").path("count");
        NodesStats nodesStats = NodesStats.create(countStats.path("total").asInt(-1), countStats.path("master_only").asInt(-1), countStats.path("data_only").asInt(-1), countStats.path("master_data").asInt(-1), countStats.path("client").asInt(-1));
        JsonNode clusterIndicesStats = clusterStatsResponseJson.path("indices");
        IndicesStats indicesStats = IndicesStats.create(clusterIndicesStats.path("count").asInt(-1), clusterIndicesStats.path("store").path("size_in_bytes").asLong(-1L), clusterIndicesStats.path("fielddata").path("memory_size_in_bytes").asLong(-1L));
        Object pendingClusterTasksResponse = JestUtils.execute(this.jestClient, new PendingClusterTasks.Builder().build(), () -> "Couldn't read Elasticsearch pending cluster tasks");
        JsonNode pendingClusterTasks = pendingClusterTasksResponse.getJsonObject().path("tasks");
        int pendingTasksSize = pendingClusterTasks.size();
        ArrayList pendingTasksTimeInQueue = Lists.newArrayListWithCapacity((int)pendingTasksSize);
        for (JsonNode jsonElement : pendingClusterTasks) {
            if (!jsonElement.has("time_in_queue_millis")) continue;
            pendingTasksTimeInQueue.add(jsonElement.get("time_in_queue_millis").asLong());
        }
        Health clusterHealthRequest = ((Health.Builder)new Health.Builder().addIndex(Arrays.asList(this.indexSetRegistry.getIndexWildcards()))).build();
        Object clusterHealthResponse = JestUtils.execute(this.jestClient, clusterHealthRequest, () -> "Couldn't read Elasticsearch cluster health");
        JsonNode clusterHealthJson = clusterHealthResponse.getJsonObject();
        ClusterHealth clusterHealth = ClusterHealth.create(clusterHealthJson.path("number_of_nodes").asInt(-1), clusterHealthJson.path("number_of_data_nodes").asInt(-1), clusterHealthJson.path("active_shards").asInt(-1), clusterHealthJson.path("relocating_shards").asInt(-1), clusterHealthJson.path("active_primary_shards").asInt(-1), clusterHealthJson.path("initializing_shards").asInt(-1), clusterHealthJson.path("unassigned_shards").asInt(-1), clusterHealthJson.path("timed_out").asBoolean(), pendingTasksSize, pendingTasksTimeInQueue);
        ElasticsearchStats.HealthStatus healthStatus = this.getHealthStatus(clusterHealthJson.path("status").asText("RED"));
        return ElasticsearchStats.create(clusterName, clusterVersion, healthStatus, clusterHealth, nodesStats, indicesStats);
    }

    private ElasticsearchStats.HealthStatus getHealthStatus(String status) {
        return ElasticsearchStats.HealthStatus.valueOf(status.toUpperCase(Locale.ENGLISH));
    }
}

