/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.timeranges;

import com.google.common.base.Strings;
import java.util.Map;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimeRangeFactory {
    public TimeRange create(Map<String, Object> timerangeConfig) throws InvalidRangeParametersException {
        String rangeType;
        String string = rangeType = Strings.isNullOrEmpty((String)((String)timerangeConfig.get("type"))) ? (String)timerangeConfig.get("range_type") : (String)timerangeConfig.get("type");
        if (Strings.isNullOrEmpty((String)rangeType)) {
            throw new InvalidRangeParametersException("range type not set");
        }
        switch (rangeType) {
            case "relative": {
                return RelativeRange.create(Integer.parseInt(String.valueOf(timerangeConfig.get("range"))));
            }
            case "keyword": {
                return KeywordRange.create((String)timerangeConfig.get("keyword"));
            }
            case "absolute": {
                String from = new DateTime(timerangeConfig.get("from"), DateTimeZone.UTC).toString();
                String to = new DateTime(timerangeConfig.get("to"), DateTimeZone.UTC).toString();
                return AbsoluteRange.create(from, to);
            }
        }
        throw new InvalidRangeParametersException("range_type not recognized");
    }
}

