/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.fields.providers;

import org.graylog.events.event.EventWithContext;
import org.graylog.events.fields.FieldValue;
import org.graylog.events.fields.providers.FieldValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFieldValueProvider
implements FieldValueProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFieldValueProvider.class);
    private final FieldValueProvider.Config config;

    public AbstractFieldValueProvider(FieldValueProvider.Config config) {
        this.config = config;
    }

    @Override
    public FieldValue get(String fieldName, EventWithContext eventWithContext) {
        try {
            return this.doGet(fieldName, eventWithContext);
        }
        catch (Exception e) {
            LOG.error("Couldn't execute field value provider: {}", (Object)this.config, (Object)e);
            return FieldValue.error();
        }
    }

    protected abstract FieldValue doGet(String var1, EventWithContext var2);

    public static interface Factory<TYPE extends FieldValueProvider>
    extends FieldValueProvider.Factory<TYPE> {
        @Override
        public TYPE create(FieldValueProvider.Config var1);
    }
}

