/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.contentpack.entities.HttpEventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.events.notifications.types.AutoValue_HTTPEventNotificationConfig;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;

@JsonTypeName(value="http-notification-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class HTTPEventNotificationConfig
implements EventNotificationConfig {
    public static final String TYPE_NAME = "http-notification-v1";
    private static final String FIELD_URL = "url";

    @JsonProperty(value="url")
    public abstract String url();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.url().isEmpty()) {
            validation.addError(FIELD_URL, "HTTP Notification url cannot be empty.");
        }
        return validation;
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return HttpEventNotificationConfigEntity.builder().url(ValueReference.of(this.url())).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_HTTPEventNotificationConfig.Builder().type(HTTPEventNotificationConfig.TYPE_NAME);
        }

        @JsonProperty(value="url")
        public abstract Builder url(String var1);

        public abstract HTTPEventNotificationConfig build();
    }
}

