/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import java.util.Objects;
import java.util.Optional;
import org.graylog.events.processor.EventDefinition;

public class EventProcessorException
extends Exception {
    private final String eventDefinitionId;
    private final boolean permanent;
    private EventDefinition eventDefinition;

    public EventProcessorException(String message, boolean permanent, String eventDefinitionId) {
        super(message);
        this.permanent = permanent;
        this.eventDefinitionId = Objects.requireNonNull(eventDefinitionId, "eventDefinitionId cannot be null");
    }

    public EventProcessorException(String message, boolean permanent, EventDefinition eventDefinition) {
        super(message);
        this.permanent = permanent;
        this.eventDefinition = Objects.requireNonNull(eventDefinition, "eventDefinition cannot be null");
        this.eventDefinitionId = Objects.requireNonNull(eventDefinition.id(), "eventDefinitionId cannot be null");
    }

    public EventProcessorException(String message, boolean permanent, String eventDefinitionId, EventDefinition eventDefinition) {
        super(message);
        this.permanent = permanent;
        this.eventDefinitionId = Objects.requireNonNull(eventDefinitionId, "eventDefinitionId cannot be null");
        this.eventDefinition = Objects.requireNonNull(eventDefinition, "eventDefinition cannot be null");
    }

    public EventProcessorException(String message, boolean permanent, String eventDefinitionId, EventDefinition eventDefinition, Throwable cause) {
        super(message, cause);
        this.permanent = permanent;
        this.eventDefinitionId = Objects.requireNonNull(eventDefinitionId, "eventDefinitionId cannot be null");
        this.eventDefinition = Objects.requireNonNull(eventDefinition, "eventDefinition cannot be null");
    }

    public EventProcessorException(String message, boolean permanent, EventDefinition eventDefinition, Throwable cause) {
        super(message, cause);
        this.permanent = permanent;
        this.eventDefinition = Objects.requireNonNull(eventDefinition, "eventDefinition cannot be null");
        this.eventDefinitionId = Objects.requireNonNull(eventDefinition.id(), "eventDefinitionId cannot be null");
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public String getEventDefinitionId() {
        return this.eventDefinitionId;
    }

    public Optional<EventDefinition> getEventDefinition() {
        return Optional.ofNullable(this.eventDefinition);
    }
}

