/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.google.common.base.Strings;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Average;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Cardinality;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Max;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Min;
import org.graylog.plugins.views.search.searchtypes.pivot.series.StdDev;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Sum;
import org.graylog.plugins.views.search.searchtypes.pivot.series.SumOfSquares;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Variance;

public enum AggregationFunction {
    AVG((id, field) -> Average.builder().id((String)id).field((String)field).build(), true),
    CARD((id, field) -> Cardinality.builder().id((String)id).field((String)field).build(), true),
    COUNT((id, field) -> Count.builder().id((String)id).field((String)field).build(), false),
    MAX((id, field) -> Max.builder().id((String)id).field((String)field).build(), true),
    MIN((id, field) -> Min.builder().id((String)id).field((String)field).build(), true),
    STDDEV((id, field) -> StdDev.builder().id((String)id).field((String)field).build(), true),
    SUM((id, field) -> Sum.builder().id((String)id).field((String)field).build(), true),
    SUMOFSQUARES((id, field) -> SumOfSquares.builder().id((String)id).field((String)field).build(), true),
    VARIANCE((id, field) -> Variance.builder().id((String)id).field((String)field).build(), true);

    private final BiFunction<String, String, SeriesSpec> seriesSpecSupplier;
    private final boolean requiresField;

    private AggregationFunction(BiFunction<String, String, SeriesSpec> seriesSpecFunction, boolean requiresField) {
        this.requiresField = requiresField;
        this.seriesSpecSupplier = Objects.requireNonNull(seriesSpecFunction, "SeriesSpec supplier cannot be null");
    }

    public SeriesSpec toSeriesSpec(String id, @Nullable String field) {
        if (this.requiresField && Strings.isNullOrEmpty((String)field)) {
            throw new IllegalArgumentException("Function <" + this.toString().toLowerCase(Locale.US) + "> requires a field");
        }
        return this.seriesSpecSupplier.apply(id, field);
    }

    public String toSeriesId(Optional<String> field) {
        return String.format(Locale.US, "%s-%s", this.name().toLowerCase(Locale.US), field.orElse(""));
    }
}

