/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import org.graylog.events.search.EventsSearchParameters;
import org.graylog.events.search.EventsSearchResult;

final class AutoValue_EventsSearchResult
extends EventsSearchResult {
    private final List<EventsSearchResult.Event> events;
    private final Set<String> usedIndices;
    private final EventsSearchParameters parameters;
    private final long totalEvents;
    private final long duration;
    private final EventsSearchResult.Context context;

    private AutoValue_EventsSearchResult(List<EventsSearchResult.Event> events, Set<String> usedIndices, EventsSearchParameters parameters, long totalEvents, long duration, EventsSearchResult.Context context) {
        this.events = events;
        this.usedIndices = usedIndices;
        this.parameters = parameters;
        this.totalEvents = totalEvents;
        this.duration = duration;
        this.context = context;
    }

    @Override
    @JsonProperty(value="events")
    public List<EventsSearchResult.Event> events() {
        return this.events;
    }

    @Override
    @JsonProperty(value="used_indices")
    public Set<String> usedIndices() {
        return this.usedIndices;
    }

    @Override
    @JsonProperty(value="parameters")
    public EventsSearchParameters parameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="total_events")
    public long totalEvents() {
        return this.totalEvents;
    }

    @Override
    @JsonProperty(value="duration")
    public long duration() {
        return this.duration;
    }

    @Override
    @JsonProperty(value="context")
    public EventsSearchResult.Context context() {
        return this.context;
    }

    public String toString() {
        return "EventsSearchResult{events=" + this.events + ", usedIndices=" + this.usedIndices + ", parameters=" + this.parameters + ", totalEvents=" + this.totalEvents + ", duration=" + this.duration + ", context=" + this.context + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventsSearchResult) {
            EventsSearchResult that = (EventsSearchResult)o;
            return this.events.equals(that.events()) && this.usedIndices.equals(that.usedIndices()) && this.parameters.equals(that.parameters()) && this.totalEvents == that.totalEvents() && this.duration == that.duration() && this.context.equals(that.context());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.events.hashCode();
        h$ *= 1000003;
        h$ ^= this.usedIndices.hashCode();
        h$ *= 1000003;
        h$ ^= this.parameters.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.totalEvents >>> 32 ^ this.totalEvents);
        h$ *= 1000003;
        h$ ^= (int)(this.duration >>> 32 ^ this.duration);
        h$ *= 1000003;
        return h$ ^= this.context.hashCode();
    }

    static final class Builder
    extends EventsSearchResult.Builder {
        private List<EventsSearchResult.Event> events;
        private Set<String> usedIndices;
        private EventsSearchParameters parameters;
        private Long totalEvents;
        private Long duration;
        private EventsSearchResult.Context context;

        Builder() {
        }

        @Override
        public EventsSearchResult.Builder events(List<EventsSearchResult.Event> events) {
            if (events == null) {
                throw new NullPointerException("Null events");
            }
            this.events = events;
            return this;
        }

        @Override
        public EventsSearchResult.Builder usedIndices(Set<String> usedIndices) {
            if (usedIndices == null) {
                throw new NullPointerException("Null usedIndices");
            }
            this.usedIndices = usedIndices;
            return this;
        }

        @Override
        public EventsSearchResult.Builder parameters(EventsSearchParameters parameters) {
            if (parameters == null) {
                throw new NullPointerException("Null parameters");
            }
            this.parameters = parameters;
            return this;
        }

        @Override
        public EventsSearchResult.Builder totalEvents(long totalEvents) {
            this.totalEvents = totalEvents;
            return this;
        }

        @Override
        public EventsSearchResult.Builder duration(long duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public EventsSearchResult.Builder context(EventsSearchResult.Context context) {
            if (context == null) {
                throw new NullPointerException("Null context");
            }
            this.context = context;
            return this;
        }

        @Override
        public EventsSearchResult build() {
            String missing = "";
            if (this.events == null) {
                missing = missing + " events";
            }
            if (this.usedIndices == null) {
                missing = missing + " usedIndices";
            }
            if (this.parameters == null) {
                missing = missing + " parameters";
            }
            if (this.totalEvents == null) {
                missing = missing + " totalEvents";
            }
            if (this.duration == null) {
                missing = missing + " duration";
            }
            if (this.context == null) {
                missing = missing + " context";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EventsSearchResult(this.events, this.usedIndices, this.parameters, this.totalEvents, this.duration, this.context);
        }
    }
}

