/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import org.graylog.events.search.AutoValue_EventsSearchParameters;
import org.graylog.events.search.EventsSearchFilter;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventsSearchParameters {
    private static final String FIELD_PAGE = "page";
    private static final String FIELD_PER_PAGE = "per_page";
    private static final String FIELD_TIMERANGE = "timerange";
    private static final String FIELD_QUERY = "query";
    private static final String FIELD_FILTER = "filter";
    private static final String FIELD_SORT_BY = "sort_by";
    private static final String FIELD_SORT_DIRECTION = "sort_direction";

    @JsonProperty(value="page")
    public abstract int page();

    @JsonProperty(value="per_page")
    public abstract int perPage();

    @JsonProperty(value="timerange")
    public abstract TimeRange timerange();

    @JsonProperty(value="query")
    public abstract String query();

    @JsonProperty(value="filter")
    public abstract EventsSearchFilter filter();

    @JsonProperty(value="sort_by")
    public abstract String sortBy();

    @JsonProperty(value="sort_direction")
    public abstract SortDirection sortDirection();

    public static Builder builder() {
        return Builder.create();
    }

    public static EventsSearchParameters empty() {
        return EventsSearchParameters.builder().build();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            RelativeRange timerange = null;
            try {
                timerange = RelativeRange.create(3600);
            }
            catch (InvalidRangeParametersException invalidRangeParametersException) {
                // empty catch block
            }
            return new AutoValue_EventsSearchParameters.Builder().page(1).perPage(10).timerange(timerange).query("").filter(EventsSearchFilter.empty()).sortBy("timestamp").sortDirection(SortDirection.DESC);
        }

        @JsonProperty(value="page")
        public abstract Builder page(int var1);

        @JsonProperty(value="per_page")
        public abstract Builder perPage(int var1);

        @JsonProperty(value="timerange")
        public abstract Builder timerange(TimeRange var1);

        @JsonProperty(value="query")
        public abstract Builder query(String var1);

        @JsonProperty(value="filter")
        public abstract Builder filter(EventsSearchFilter var1);

        @JsonProperty(value="sort_by")
        public abstract Builder sortBy(String var1);

        @JsonProperty(value="sort_direction")
        public abstract Builder sortDirection(SortDirection var1);

        public abstract EventsSearchParameters build();
    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

