/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graylog.events.event.EventDto;
import org.graylog.events.search.AutoValue_EventsSearchResult;
import org.graylog.events.search.AutoValue_EventsSearchResult_Context;
import org.graylog.events.search.AutoValue_EventsSearchResult_ContextEntity;
import org.graylog.events.search.AutoValue_EventsSearchResult_Event;
import org.graylog.events.search.EventsSearchParameters;

@JsonAutoDetect
@AutoValue
public abstract class EventsSearchResult {
    @JsonProperty(value="events")
    public abstract List<Event> events();

    @JsonProperty(value="used_indices")
    public abstract Set<String> usedIndices();

    @JsonProperty(value="parameters")
    public abstract EventsSearchParameters parameters();

    @JsonProperty(value="total_events")
    public abstract long totalEvents();

    @JsonProperty(value="duration")
    public abstract long duration();

    @JsonProperty(value="context")
    public abstract Context context();

    public static Builder builder() {
        return new AutoValue_EventsSearchResult.Builder();
    }

    @AutoValue
    public static abstract class ContextEntity {
        @JsonProperty(value="id")
        public abstract String id();

        @JsonProperty(value="title")
        public abstract String title();

        @JsonProperty(value="description")
        public abstract String description();

        public static ContextEntity create(String id, String title, String description) {
            return new AutoValue_EventsSearchResult_ContextEntity(id, title, description);
        }
    }

    @AutoValue
    public static abstract class Context {
        @JsonProperty(value="event_definitions")
        public abstract ImmutableMap<String, ContextEntity> eventDefinitions();

        @JsonProperty(value="streams")
        public abstract ImmutableMap<String, ContextEntity> streams();

        public static Context create(Map<String, ContextEntity> eventDefinitions, Map<String, ContextEntity> streams) {
            return new AutoValue_EventsSearchResult_Context((ImmutableMap<String, ContextEntity>)ImmutableMap.copyOf(eventDefinitions), (ImmutableMap<String, ContextEntity>)ImmutableMap.copyOf(streams));
        }
    }

    @AutoValue
    public static abstract class Event {
        @JsonProperty(value="event")
        public abstract EventDto event();

        @JsonProperty(value="index_name")
        public abstract String indexName();

        @JsonProperty(value="index_type")
        public abstract String indexType();

        public static Event create(EventDto event, String indexName, String indexType) {
            return new AutoValue_EventsSearchResult_Event(event, indexName, indexType);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder events(List<Event> var1);

        public abstract Builder usedIndices(Set<String> var1);

        public abstract Builder parameters(EventsSearchParameters var1);

        public abstract Builder totalEvents(long var1);

        public abstract Builder duration(long var1);

        public abstract Builder context(Context var1);

        public abstract EventsSearchResult build();
    }
}

