/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.freeenterprise;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.freeenterprise.FreeEnterpriseService;
import org.graylog.freeenterprise.FreeLicenseRequest;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Enterprise")
@Path(value="/free-enterprise")
@Produces(value={"application/json"})
@RequiresAuthentication
public class FreeEnterpriseResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(FreeEnterpriseResource.class);
    private final FreeEnterpriseService freeEnterpriseService;

    @Inject
    public FreeEnterpriseResource(FreeEnterpriseService freeEnterpriseService) {
        this.freeEnterpriseService = freeEnterpriseService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get Graylog Enterprise license info")
    @Path(value="/license/info")
    @RequiresPermissions(value={"licenseinfos:read"})
    public Response licenseInfo() {
        return Response.ok(Collections.singletonMap("free_license_info", this.freeEnterpriseService.licenseInfo())).build();
    }

    @POST
    @Timed
    @ApiOperation(value="Request free Graylog Enterprise license")
    @Path(value="/license")
    @RequiresPermissions(value={"freelicenses:create"})
    @NoAuditEvent(value="This will be used to get a license. Without license triggering an audit event doesn't make sense.")
    public Response requestFreeLicense(@NotNull @Valid FreeLicenseRequest request) {
        if (this.freeEnterpriseService.canRequestFreeLicense()) {
            try {
                this.freeEnterpriseService.requestFreeLicense(request);
            }
            catch (Exception e) {
                throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
            }
            return Response.accepted().build();
        }
        throw new BadRequestException("Free Graylog Enterprise license already requested or license already installed");
    }
}

