/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.grn;

import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.graylog.grn.AutoValue_GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;

@AutoValue
public abstract class GRN {
    private static final Splitter SPLITTER = Splitter.on((String)":").trimResults();

    public abstract String cluster();

    public abstract String tenant();

    public abstract String scope();

    public abstract String type();

    public abstract String entity();

    public abstract GRNType grnType();

    public boolean isPermissionApplicable(String permission) {
        return permission.startsWith("entity:own") || permission.startsWith(this.grnType().permissionPrefix()) || this.grnType().equals(GRNTypes.DASHBOARD) && permission.startsWith(GRNTypes.SEARCH.permissionPrefix());
    }

    static GRN parse(String grn, GRNRegistry grnRegistry) {
        List tokens = SPLITTER.splitToList((CharSequence)grn.toLowerCase(Locale.ENGLISH));
        if (tokens.size() != 6) {
            throw new IllegalArgumentException(String.format(Locale.US, "<%s> is not a valid GRN string", grn));
        }
        if (!((String)tokens.get(0)).equals("grn")) {
            throw new IllegalArgumentException(String.format(Locale.US, "<%s> is not a grn scheme", tokens.get(0)));
        }
        String type = (String)tokens.get(4);
        Builder builder = grnRegistry.newGRNBuilder(type).cluster((String)tokens.get(1)).tenant((String)tokens.get(2)).scope((String)tokens.get(3)).entity((String)tokens.get(5));
        return builder.build();
    }

    public static Builder builder() {
        return new AutoValue_GRN.Builder().cluster("").tenant("").scope("");
    }

    public abstract Builder toBuilder();

    public String toString() {
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("grn").add(this.cluster()).add(this.tenant()).add(this.scope()).add(this.type()).add(this.entity());
        return joiner.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GRN) {
            GRN that = (GRN)o;
            return this.toString().equals(that.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder cluster(String var1);

        public abstract Builder tenant(String var1);

        public abstract Builder scope(String var1);

        public abstract Builder type(String var1);

        public abstract Builder entity(String var1);

        public abstract Builder grnType(GRNType var1);

        public abstract GRN build();
    }
}

