/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PrometheusMetricFilter
implements MetricFilter {
    private final List<Pattern> patterns;

    public PrometheusMetricFilter(List<MapperConfig> mapperConfigs) {
        this.patterns = mapperConfigs.stream().map(mc -> this.globToRegex(mc.getMatch())).collect(Collectors.toList());
    }

    public boolean matches(String name, Metric metric) {
        return this.patterns.stream().anyMatch(pattern -> pattern.matcher(name).matches());
    }

    private Pattern globToRegex(String glob) {
        String[] parts = glob.split(Pattern.quote("*"), -1);
        StringBuilder escapedPattern = new StringBuilder(Pattern.quote(parts[0]));
        for (int i = 1; i < parts.length; ++i) {
            escapedPattern.append("([^.]*)").append(Pattern.quote(parts[i]));
        }
        return Pattern.compile("^" + escapedPattern + "$");
    }
}

