/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus.mapping;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.metrics.prometheus.mapping.PrometheusMappingConfig;
import org.graylog2.plugin.system.NodeId;

public class PrometheusMappingConfigLoader {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final NodeId nodeId;

    @Inject
    public PrometheusMappingConfigLoader(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public Set<MapperConfig> load(InputStream inputStream) throws IOException {
        PrometheusMappingConfig config = (PrometheusMappingConfig)YAML_MAPPER.readValue(inputStream, PrometheusMappingConfig.class);
        return config.metricMappings().stream().map(this::mapMetric).collect(Collectors.toSet());
    }

    private MapperConfig mapMetric(PrometheusMappingConfig.MetricMapping mapping) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("node", this.nodeId.toString());
        labels.putAll((Map<String, String>)mapping.additionalLabels());
        for (int i = 0; i < mapping.wildcardExtractLabels().size(); ++i) {
            labels.put((String)mapping.wildcardExtractLabels().get(i), "${" + i + "}");
        }
        return new MapperConfig(mapping.matchPattern(), "gl_" + mapping.metricName(), labels);
    }
}

